# 波动数列
#### 问题描述
观察这个数列：  
1 3 0 2 -1 1 -2 ...  
这个数列中后一项总是比前一项增加2或者减少3。  
栋栋对这种数列很好奇，他想知道长度为 ```n``` 和为 ```s``` 而且后一项总是比前一项增加a或者减少b的整数数列可能有多少种呢？  
#### 输入格式
　　输入的第一行包含四个整数``` n s a b```，含义如前面说述。
#### 输出格式
　　输出一行，包含一个整数，表示满足条件的方案数。由于这个数很大，请输出方案数除以100000007的余数。
#### 样例输入
```4 10 2 3```
#### 样例输出
```2```
#### 样例说明
这两个数列分别是```2 4 1 3```和```7 4 1 -2```。
#### 数据规模和约定
对于10%的数据，1<=n<=5，0<=s<=5，1<=a,b<=5；  
对于30%的数据，1<=n<=30，0<=s<=30，1<=a,b<=30；  
对于50%的数据，1<=n<=50，0<=s<=50，1<=a,b<=50；  
对于70%的数据，1<=n<=100，0<=s<=500，1<=a, b<=50；  
对于100%的数据，1<=n<=1000，-1,000,000,000<=s<=1,000,000,000，1<=a, b<=1,000,000。  


## aop
### before
```cpp
#include <iostream>
#include <cstdio>
#include <cstring>
using namespace std;
typedef long long ll;
const int N = 1e3 + 5;
const int mod = 100000007;
int n, s, a, b, up;
ll v;
int dp[2][N * (N + 1) / 2], now;
int ans;
```
### after
```cpp

```

## 答案
```cpp
int main()
{
	scanf("%d%d%d%d", &n, &s, &a, &b);
	dp[now][0] = 1;
	for (int i = 1; i < n; ++i) 
	{
		now = !now;
		up = i * (i + 1) / 2;
		for (int j = 0; j <= up; ++j) 
		{
			dp[now][j] = dp[!now][j];
			if (j >= i)
				dp[now][j] = (dp[now][j] + dp[!now][j - i]) % mod;
		}
	}
	for (int i = 0; i <= up; ++i) 
	{
		v = 1ll * s - 1ll * i * a + 1ll * (up - i) * b;
		if (v % n == 0)
			ans = (ans + dp[now][i]) % mod;
	}
	printf("%d\n", ans);
	return 0;
}
```
## 选项

### A
```cpp
int main()
{
	scanf("%d%d%d%d", &n, &s, &a, &b);
	dp[now][0] = 1;
	for (int i = 1; i < n; ++i) 
	{
		now = !now;
		up = i * (i + 1) / 2;
		for (int j = 0; j <= up; ++j) 
		{
			dp[now][j] = dp[now][j];
			if (j >= i)
				dp[now][j] = (dp[now][j] + dp[!now][j - i]) % mod;
		}
	}
	for (int i = 0; i <= up; ++i) 
	{
		v = 1ll * s - 1ll * i * a + 1ll * (up - i) * b;
		if (v % n == 0)
			ans = (ans + dp[now][i]) % mod;
	}
	printf("%d\n", ans);
	return 0;
}
```

### B
```cpp
int main()
{
	scanf("%d%d%d%d", &n, &s, &a, &b);
	dp[now][0] = 1;
	for (int i = 1; i < n; ++i) 
	{
		up = i * (i + 1) / 2;
		for (int j = 0; j <= up; ++j) 
		{
			dp[now][j] = dp[!now][j];
			if (j >= i)
				dp[now][j] = (dp[now][j] + dp[now][j - i]) % mod;
		}
	}
	for (int i = 0; i <= up; ++i) 
	{
		v = 1ll * s - 1ll * i * a + 1ll * (up - i) * b;
		if (v % n == 0)
			ans = (ans + dp[now][i]) % mod;
	}
	printf("%d\n", ans);
	return 0;
}
```

### C
```cpp
int main()
{
	scanf("%d%d%d%d", &n, &s, &a, &b);
	dp[now][0] = 1;
	for (int i = 1; i < n; ++i) 
	{
		up = i * (i + 1) / 2;
		for (int j = 0; j <= up; ++j) 
		{
			dp[now][j] = dp[!now][j];
			if (j >= i)
				dp[now][j] = (dp[!now][j] + dp[!now][j - i]) % mod;
		}
	}
	for (int i = 0; i <= up; ++i) 
	{
		v = 1ll * s - 1ll * i * a + 1ll * (up - i) * b;
		if (v % n == 0)
			ans = (ans + dp[now][i]) % mod;
	}
	printf("%d\n", ans);
	return 0;
}
```
