# 第39级台阶

小明刚刚看完电影《第39级台阶》，离开电影院的时候，他数了数礼堂前的台阶数，恰好是39级!

站在台阶前，他突然又想着一个问题：

如果我每一步只能迈上1个或2个台阶。先迈左脚，然后左右交替，最后一步是迈右脚，也就是说一共要走偶数步。那么，上完39级台阶，有多少种不同的上法呢？

请你利用计算机的优势，帮助小明寻找答案。


以下哪一项不能得到正确答案？

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp

```

## 答案

```cpp
int ans = 0;
int sum = 0;
vector<int> a(40, 0);

void dfs(int steps)
{
    if (sum >= 39)
    {
        if ((steps - 1) % 2 == 0 && sum == 39)
            ans++;
        return;
    }

    for (int i = 1; i <= 2; i++)
    {
        a[steps] = i;
        sum += i;
        dfs(steps + 1);
        sum -= i;
    }
}

int main()
{
    dfs(0);
    cout << ans << endl;
    return 0;
}
```
## 选项


### A

```cpp
int ans = 0;
void dfs(int k, int n)
{
    if (k == 39 && n % 2 == 0)
    {
        ans++;
    }
    if (k > 39)
        return;
    dfs(k + 1, n + 1);
    dfs(k + 2, n + 1);
}
int main()
{

    dfs(0, 0);
    printf("%d\n", ans);

    return 0;
}
```

### B

```cpp
int countt = 0;

void f(int stair, int step)
{
    if (stair < 0)
        return;
    if (step % 2 == 0 && stair == 0)
    {
        countt++;
        return;
    }
    for (int i = 1; i <= 2; i++)
    {
        f(stair - i, step + 1);
    }
}

int main(void)
{
    f(39, 0);
    cout << countt << endl;
    return 0;
}
```

### C

```cpp
#define LEFT 0
#define RIGHT 1
using namespace std;
int stage[40][2];

int main()
{
    int i;
    stage[1][LEFT] = 1;
    stage[1][RIGHT] = 0;
    stage[2][LEFT] = 1;
    stage[2][RIGHT] = 1;
    for (i = 3; i <= 39; i++)
    {
        stage[i][LEFT] = stage[i - 1][RIGHT] + stage[i - 2][RIGHT];
        stage[i][RIGHT] = stage[i - 1][LEFT] + stage[i - 2][LEFT];
    }
    cout << stage[39][RIGHT] << endl;
    return 0;
}
```
