# 格子中输出

StringInGrid函数会在一个指定大小的格子中打印指定的字符串。 要求字符串在水平、垂直两个方向上都居中。 如果字符串太长，就截断。 如果不能恰好居中，可以稍稍偏左或者偏上一点。  

输出：

![](https://img-blog.csdnimg.cn/20200327144609874.png#pic_center)

以下程序实现了这一功能，请你补全空白处内容：

```c
#include <stdio.h>
#include <string.h>
void StringInGrid(int width, int height, const char *s)
{
    int i, k;
    char buf[1000];
    strcpy(buf, s);
    if (strlen(s) > width - 2)
        buf[width - 2] = 0;
    printf("+");
    for (i = 0; i < width - 2; i++)
        printf("-");
    printf("+\n");
    for (k = 1; k < (height - 1) / 2; k++)
    {
        printf("|");
        for (i = 0; i < width - 2; i++)
            printf(" ");
        printf("|\n");
    }
    printf("|");
    printf("%*s%s%*s", __________________;
    printf("|\n");
    for (k = (height - 1) / 2 + 1; k < height - 1; k++)
    {
        printf("|");
        for (i = 0; i < width - 2; i++)
            printf(" ");
        printf("|\n");
    }
    printf("+");
    for (i = 0; i < width - 2; i++)
        printf("-");
    printf("+\n");
}

int main()
{
    StringInGrid(20, 6, "abcd1234");
    return 0;
}
```


## 答案

```c
(width - strlen(buf) - 2) / 2, "", buf, (width - strlen(buf) - 2) / 2, ""
```

## 选项

### A

```c
(width - strlen(buf) - 1) / 2, "", buf, (width - strlen(buf) - 1) / 2, ""
```

### B

```c
(width - strlen(buf) + 1) / 2, "", buf, (width - strlen(buf) + 1) / 2, ""
```

### C

```c
(width - strlen(buf) - 2), "", buf, (width - strlen(buf) - 2), ""
```
