# 文本左右对齐
<div class="notranslate">
  <p>给定一个单词数组和一个长度&nbsp;<em>maxWidth</em>，重新排版单词，使其成为每行恰好有&nbsp;<em>maxWidth</em>&nbsp;个字符，且左右两端对齐的文本。</p>

  <p>你应该使用“贪心算法”来放置给定的单词；也就是说，尽可能多地往每行中放置单词。必要时可用空格&nbsp;<code>' '</code>&nbsp;填充，使得每行恰好有 <em>maxWidth</em>&nbsp;个字符。
  </p>

  <p>要求尽可能均匀分配单词间的空格数量。如果某一行单词间的空格不能均匀分配，则左侧放置的空格数要多于右侧的空格数。</p>

  <p>文本的最后一行应为左对齐，且单词之间不插入<strong>额外的</strong>空格。</p>

  <p><strong>说明:</strong></p>

  <ul>
    <li>单词是指由非空格字符组成的字符序列。</li>
    <li>每个单词的长度大于 0，小于等于&nbsp;<em>maxWidth</em>。</li>
    <li>输入单词数组 <code>words</code>&nbsp;至少包含一个单词。</li>
  </ul>

  <p><strong>示例:</strong></p>

  <pre><strong>输入:</strong>
    words = ["This", "is", "an", "example", "of", "text", "justification."]
    maxWidth = 16
<strong><br />输出:</strong>
    [
    &nbsp; &nbsp;"This &nbsp; &nbsp;is &nbsp; &nbsp;an",
    &nbsp; &nbsp;"example &nbsp;of text",
    &nbsp; &nbsp;"justification. &nbsp;"
    ]
    </pre>

  <p><strong>示例&nbsp;2:</strong></p>

  <pre><strong>输入:</strong>
    words = ["What","must","be","acknowledgment","shall","be"]
    maxWidth = 16
<strong><br />输出:</strong>
    [
    &nbsp; "What &nbsp; must &nbsp; be",
    &nbsp; "acknowledgment &nbsp;",
    &nbsp; "shall be &nbsp; &nbsp; &nbsp; &nbsp;"
    ]
<strong><br />解释: </strong>注意最后一行的格式应为 "shall be    " 而不是 "shall     be"
    因为最后一行应为左对齐，而不是左右两端对齐，第二行同样为左对齐，这是因为这行只包含一个单词。
    </pre>

  <p><strong>示例&nbsp;3:</strong></p>

  <pre><strong>输入:</strong>
    words = ["Science","is","what","we","understand","well","enough","to","explain",
    &nbsp;        "to","a","computer.","Art","is","everything","else","we","do"]
    maxWidth = 20
<strong><br />输出:</strong>
    [
    &nbsp; "Science &nbsp;is &nbsp;what we",
      "understand &nbsp; &nbsp; &nbsp;well",
    &nbsp; "enough to explain to",
    &nbsp; "a &nbsp;computer. &nbsp;Art is",
    &nbsp; "everything &nbsp;else &nbsp;we",
    &nbsp; "do &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;"
    ]
    </pre>
</div>
<p>以下错误的选项是？</p>
## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    vector<string> words = {"Science", "is", "what", "we", "understand", "well", "enough", "to", "explain",
                            "to", "a", "computer.", "Art", "is", "everything", "else", "we", "do"};
    int maxWidth = 20;
    vector<string> res;
    res = sol.fullJustify(words, maxWidth);
    for (auto i : res)
        cout << i << " " << endl;
    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    vector<string> fullJustify(vector<string> &words, int maxWidth)
    {
        vector<string> result;
        int wordsVecSize = words.size();
        for (int beginIndex = 0; beginIndex < wordsVecSize;)
        {
            string tempRec = words[beginIndex];
            int remainLength = maxWidth - words[beginIndex].size();
            int cnt = 1;
            int endIndex = beginIndex + 1;

            while (endIndex < wordsVecSize)
            {
                int tempVaule = remainLength - words[endIndex].size();
                if (tempVaule >= cnt)
                {
                    remainLength = tempVaule;
                    cnt += 1;
                    ++endIndex;
                }
                else
                {
                    break;
                }
            }
            if (cnt == 1)
            {
                tempRec = string(remainLength, ' ');
            }
            else if (endIndex != wordsVecSize)
            {
                vector<int> spaceNum(cnt, remainLength / (cnt - 1));
                remainLength %= (cnt - 1);
                for (int i = 1; i <= remainLength; ++i)
                {
                    spaceNum[i] += 1;
                }

                for (int index = beginIndex + 1; index < endIndex; ++index)
                {
                    tempRec += string(spaceNum[index - beginIndex], ' ') + words[index];
                }
            }
            else
            {
                remainLength = maxWidth - words[beginIndex].size();
                for (int index = beginIndex + 1; index < endIndex; ++index)
                {
                    tempRec += " " + words[index];
                    remainLength = remainLength - 1 - words[index].size();
                }
                tempRec += string(remainLength, ' ');
            }
            result.push_back(tempRec);
            beginIndex = endIndex;
        }
        return result;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    vector<string> fullJustify(vector<string> &words, int maxWidth)
    {
        vector<string> res;
        int i = 0;
        while (i < words.size())
        {
            int residue_wid = 0;
            int begin = i;
            while (i < words.size() && residue_wid + words[i].size() <= maxWidth)
            {
                residue_wid += words[i].size() + 1;
                ++i;
            }
            if (i == words.size())
            {
                res.push_back(packagestring(words, begin, i - 1, residue_wid - 1, maxWidth, false));
                break;
            }
            res.push_back(packagestring(words, begin, i - 1, residue_wid - 1, maxWidth, true));
        }
        return res;
    }

    string packagestring(vector<string> &words, int starter, int ender, int strlen, int maxWidth, bool tail)
    {
        string res = "";
        if (tail && starter < ender)
        {
            int cnt = ender - starter;
            int blk = (maxWidth - strlen) / cnt + 1;
            string spc = string(blk, ' ');
            int ofst = (maxWidth - strlen) % cnt;
            for (int i = starter; i < ender; ++i)
            {
                res += words[i] + spc;
                if (i - starter < ofst)
                    res += ' ';
            }
            res += words[ender];
        }
        else
        {
            string spc = string(maxWidth - strlen, ' ');
            for (int i = starter; i < ender; ++i)
            {
                res += words[i] + ' ';
            }
            res += words[ender] + spc;
        }
        return res;
    }
};
```

### B
```cpp
class Solution
{
public:
    vector<string> fullJustify(vector<string> &words, int L)
    {
        vector<string> res;
        int i = 0;
        while (i < words.size())
        {
            int j = i, len = 0;
            while (j < words.size() && len + words[j].size() + j - i <= L)
            {
                len += words[j++].size();
            }
            string out;
            int space = L - len;
            for (int k = i; k < j; ++k)
            {
                out += words[k];
                if (space > 0)
                {
                    int tmp;
                    if (j == words.size())
                    {
                        if (j - k == 1)
                            tmp = space;
                        else
                            tmp = 1;
                    }
                    else
                    {
                        if (j - k - 1 > 0)
                        {
                            if (space % (j - k - 1) == 0)
                                tmp = space / (j - k - 1);
                            else
                                tmp = space / (j - k - 1) + 1;
                        }
                        else
                            tmp = space;
                    }
                    out.append(tmp, ' ');
                    space -= tmp;
                }
            }
            res.push_back(out);
            i = j;
        }
        return res;
    }
};
```

### C
```cpp
class Solution
{
public:
    vector<string> fullJustify(vector<string> &words, int maxWidth)
    {
        int n = words.size(), length, num = 0, i, j, k;
        string now;
        vector<string> ans;
        for (i = 0; i < n;)
        {
            now.clear();
            num = 0;
            length = words[i].length();
            for (j = i; j < n - 1; j++)
            {
                if (words[j + 1].length() + length + num + 1 > maxWidth)
                    break;
                num++;
                length += words[j + 1].length();
            }
            if (j == n - 1)
            {
                for (k = i; k < n; k++)
                {
                    now += words[k];
                    if (k != n - 1)
                        now += " ";
                }
                for (k = 0; k < maxWidth - length - num; k++)
                    now += " ";
                ans.push_back(now);
            }
            else
            {
                int black = maxWidth - length;
                if (num == 0)
                {
                    now.append(words[i]);
                    now.append(black, ' ');
                    ans.push_back(now);
                }
                else
                {
                    int x = black % num;
                    int y = black / num;
                    if (x == 0)
                    {
                        string kongge;
                        for (k = 0; k < y; k++)
                            kongge += " ";
                        for (k = i; k <= j; k++)
                        {
                            now += words[k];
                            if (k != j)
                                now += kongge;
                        }
                        ans.push_back(now);
                    }
                    else
                    {
                        string kongge;
                        for (k = 0; k <= y; k++)
                            kongge += " ";
                        for (k = i; k <= j; k++)
                        {
                            now += words[k];
                            if (k != j)
                                now += kongge;
                            if (k - i + 1 == x)
                                kongge.erase(kongge.begin());
                        }
                        ans.push_back(now);
                    }
                }
            }
            i = j + 1;
        }
        return ans;
    }
};
```
