# 技能森林

技能森林由一系列开放技能树构成，本条目定义技能森林相关的概念。

## 技能树开放编辑仓库

技能树开放技能树编辑 git 仓库，使用MIT或者CC4协议，由社区协作编辑技能树骨架和习题。仓库命名规格为`skill_tree_{xx}` ，其中 `{xx}` 是技能树仓库的命名，一般和技能树的英文名称一致，少数通用缩写的也会使用缩写，例如`pg`表示`postgresql`

每个技能树仓库的 readme.md 会写明本仓库的编辑规则。技能树仓库的编辑规则基本上是保持一致的，但是每个仓库根据领域技术特点会略微有差异。

示例：
例如C语言技能树编辑仓库 https://gitcode.net/csdn/skill_tree_c

## 技能树管道工具

当开放技能树编辑仓库 `章`/`节`/`题目` 数据编辑就绪的时候。技能树管道工具会使用四个命令从技能树骨架数据构建技能树社区资源。技能树管道工具会在合理抽象后以开源的方式提交社区维护。

这四个管道命令是：

* import: 导入指定技能树编辑仓库数据
* output: 将技能树编辑仓库数据转换为中间规格数据格式，同时创建 CSDN 社区云上对应的知识点社区
* publish: 将中间规格数据格式生成为技能树节点数据和习题数据，同时创建习题所在社区的交流帖子。
* sync_db: 将技能树节点数据和习题数据合成为技能树服务数据，同时触发节点数据挂载。

## 技能树服务

技能树管道工具将开放技能树编辑仓库数据经过流水线处理装配后。由技能树服务提供技能树和技能树视图相关的一组API服务，这组API定义了什么是技能树。

技能树服务包含两层：

* 技能树基础接口服务，包含所有展开节点的API
* 技能树视图接口服务，只包含技能树社区所需API

## 技能树社区用户答题服务

用户答题服务提供用户答题相关的一组服务。

## 技能树社区

技能树社区通过装配以下资源构成了领域技能树社区，例如：clang.csdn.net, python.csdn.net

* 技能树服务提供的骨架信息
* 技能树服务提供的节点社区信息
  * 技能树服务提供的节点参考资料信息
  * 技能树服务提供的习题信息
  * 技能树服务提供的习题在节点社区里的交流贴
* 技能树社区用户答题服务

## 领域技能树用户核心学习路径

1. 系统性的有过程跟踪的学习
2. 使用参考资料
3. 通过答题验证反馈
4. 同主题交流
