# CSDN 技能森林

本仓库是技能树森林的 RFC(Request for Comments) 仓库。提议请在 rfc/ 目录下创建文档，例如 [`rfc_001.md`](./rfc/rfc_001.md)

## 如何参与贡献

1. fork 下面对应开放技能树编辑仓库，仔细阅读对应的仓库的README规则，新增习题或者改进已有习题
2. 提交 pull-request 等待审核合并
3. 核心贡献者会邀请加入项目仓库成员
4. 技能树社区将展示出题者信息，以及根据贡献值奖励一定的原力值
5. 参考[参与贡献Q/A](./qa.md)

## 技能树仓库和技能树社区

* 技能树开放编辑仓库采用 MIT 或者 CC4 开源协议
* 一个技能树仓库的章节结构和习题就绪时，则上线初版的技能树社区

| 开放编辑仓库      | 上线的技能树社区 | 状态|
| ----------- | ----------- |----------- |
|[CS入门技能树仓库](https://gitcode.net/csdn/skill_tree_git_md_linux)|[CS入门技能树社区](https://bbs.csdn.net/skill/gml)|✓TODO:增加Linux|
|[Python技能树编辑仓库](https://gitcode.net/csdn/skill_tree_python)|[Python技能树社区](http://python.csdn.net)|✓|
|[C语言技能树编辑仓库](https://gitcode.net/csdn/skill_tree_c)|[C语言技能树社区](http://clang.csdn.net)|✓|
|[Java技能树编辑仓库](https://gitcode.net/csdn/skill_tree_java)|[Java技能树社区](https://bbs.csdn.net/skill/java)|✓|
|[算法(algorithm)技能树编辑仓库](https://gitcode.net/csdn/skill_tree_algorithm)|[算法技能树社区](https://algo.csdn.net)|✓|
|[PostgreSQL技能树编辑仓库](https://gitcode.net/csdn/skill_tree_pg)|[PostgreSQL技能树社区](https://bbs.csdn.net/skill/pg)|✓|
|[OpenCV技能树编辑仓库](https://gitcode.net/csdn/skill_tree_opencv)|[OpenCV技能树社区](https://bbs.csdn.net/skill/opencv)|✓|
|[每日一题技能树编辑仓库](https://gitcode.net/csdn/skill_tree_dailycode)|[每日一练](https://dailycode.csdn.net)|✓|
|[Neo4j技能树编辑仓库](https://gitcode.net/csdn/skill_tree_neo4j)|[Neo4j技能树社区](https://bbs.csdn.net/skill/neo4j)|✓|
|[.NET技能树](https://gitcode.net/csdn/skill_tree_dotnet)| | |
|[Rust技能树](https://gitcode.net/csdn/skill_tree_rust)| | |
|[网络技能树](https://gitcode.net/csdn/skill_tree_network)| | |
|[Web技能树](https://gitcode.net/csdn/skill_tree_web)| | |
|[Web实战技能树](https://gitcode.net/csdn/skill_tree_web_in_action)| | |
|[AI技能树](https://gitcode.net/csdn/skill_tree_ai)| | |
|[OceanBase技能树](https://gitcode.net/csdn/skill_tree_oceanbase)| | |
|[DevOps运维技能树](https://gitcode.net/csdn/skill_tree_devops)| | |

## 技能树服务构建项目

技能树数据处理的流水线如下：

`技能树开放编辑仓库` --> `技能树命令行工具` --> `技能树服务`

其中 `技能树开放编辑仓库` 就是每个领域的编辑仓库。
而 `技能树命令行工具` 和 `技能树服务` 会分别创建两个独立的仓库

* skill_tree_cli（参考下一节）
* skill_tree_server（TODO）

实现上，skill_tree_cli 和 skill_tree_server 都会有一些对技能树编辑仓库数据的结构解析、校验、转换需求，这些解析器的实现托管在一个独立的 `技能树解析` 仓库里。也即：

* [skill_tree_parser](https://gitcode.net/csdn/skill_tree_parser)

## [技能树命令行设计(草稿)](https://gitcode.net/csdn/skill_tree/-/issues/4)

技能树仓库编辑命令 最终应该和 技能树管道处理命令组合在一起，类似 git 一样提供一个 skill_tree 命令，该命令包含如下 `actions`

* `init` 命令：初始化一个技能树仓库，该过程会交互式询问，输入技能树仓库相关的 meta 信息，用来自动完成技能树仓库
  * 原始数据编辑目录：data/
  * 处理脚本目录：src/
  * 管道数据处理目录：pipeline/
    * 保持结构并规格化处理输出目录：pipeline/spec
    * 链接合成目录：pipeline/link
* `tree` 命令：在data/ 目录下通过该命令为每个节点和习题分配id，自动化生成必要的元数据
* `spec` 命令：在pipeline/spec 目录下输出严格规格化的中间数据格式
* `link` 命令：链接节点数据，包含
  * 生成节社区（抽象意义上）
  * 生成节频道（抽象意义上）
  * 生成习题交流贴（抽象意义上）
* `deploy` 命令：将link后的产生的数据发布到抽象技能树服务
* `server` 命令：启动抽象技能树服务，用户可以开始使用。

## 技能树概述

内容生产者， 内容消费者，学习者： 他们有不同的需求。

从一个“产品设计” 的角度，一个领域 （Python） 有一个技能树。 这个技能树上面有很多 知识点，这些知识点有 {初中高} 的特性。 每个知识点有 相关的 {博客， 问答， 代码， 视频，... } 集合。 用户如何证明自己掌握了某个知识点？ 考虑：

* 每个知识点有相关的 “测试”，通过了这个 “测试”.
* 成为这个知识点的回答采纳目标。
* 写原创博客获得一定的赞。
* 通过某种考试。

## 痛点的解决

* 我怎么能证明我自己懂了这个领域？ 解决：显示用户花了时间，通过了测试，写了博客。
* 光看博客就能证明自己懂了么？ 解决：不行，必须通过测试了
* 我看了程序，但是只有程序片段，我怎么运行在我的电脑呢？   CSDN 的程序是完整的，但是拷贝到我的电脑上，怎么不行啊？ 解决：让用户能执行完整的可运行的程序。
* 回答者的痛点：我不断地回答相似的问题，一遍一遍给他们源代码。 解决：把完整的解决代码放在 Code 平台上，以后让提问者来这里看。 （这个和 ‘问答’ 业务很相关）

对于技能树上的一个问题，我们应该有完整的解决方案，让用户非常满意：

* 问题（怎么做归并排序？）
* 解答（原理是这样的）
* 代码：这个代码是要能在 Code-China 上可以运行的 （归并排序的代码在 JupyterNotebook 之类的平台运行）
* 解释通过代码的评论来完成：用户会说：我不大懂第十行， 为何要这样写？  专家就会解释。

## 技能树社区核心设计

1. 构建结构化信息，通过难度等级、章/节+子树，使用算法匹配学习知识
2. 每个知识点节点是一个微社区
3. 每个微社区内包含3个重要元素：
    * 参考资料（学习，使用算法匹配+推荐给出最优质内容）
    * 习题（验证学习，是否掌握了知识点？习题做完可以去Notebook运行）
    * 交流讨论区（同主题交流，通过输出进一步强化学习）