# llm-coding-eval

大模型写代码能力评测

## 目录说明

* backup/
  * 最早版本的评测，测试例子来自真实的用户查询
  * 评测体系来自基本的分类
* eval_set/
  * 体系化设计的评测用例
    * 从简单到复杂的编程粒度设计
  * 代码补全能力评测集
    * eval_set/humanval-x
      * 来自：<https://github.com/THUDM/CodeGeeX/blob/main/codegeex/benchmark/README_zh.md>
* llm_set/
  * 大模型配置列表，配置每一种大模型的元数据
* src/
  * 评测源代码
* mian.py 程序入口

## 同类评测项目

1. 斯坦福大学的评测：AlpacaEval Logo Leaderboard <https://tatsu-lab.github.io/alpaca_eval/>
2. <https://github.com/the-crypt-keeper/can-ai-code>
3. <https://github.com/THUDM/CodeGeeX/tree/main/codegeex/benchmark>
4. <https://github.com/openai/human-eval>


## HumanEval-X
HumanEval-X中每个语言的样本，包含了声明、描述和解答，它们之间的组合可以支持不同的下游任务，包括生成、翻译、概括等。我们目前关注两个任务：代码生成与代码翻译。对于代码生成任务，模型将函数声明与文档字符串作为输入，输出函数实现；对于代码翻译任务，模型将两种语言的函数声明与源语言的实现作为输入，输出目标语言上的实现。我们在代码翻译任务中不将文档字符串输入模型，以避免模型直接通过描述生成答案。在两种任务下，我们都采用Codex所使用的无偏pass@k指标：
pass@k:=𝔼[1−(<sup>n-c</sup><sub>k</sub>)/(<sup>n</sup><sub>k</sub>)], n=200,  k∈(1,10,100)。

样本使用JSON列表格式存储在codegeex/benchmark/humaneval-x/[LANG]/data/humaneval_[LANG].jsonl.gz，每条样本包含6个部分：

task_id: 题目的目标语言与ID。语言为["Python", "Java", "JavaScript", "CPP", "Go"]中之一。  
prompt: 函数声明与描述，用于代码生成。  
declaration: 仅有函数声明，用于代码翻译。  
canonical_solution: 手写的示例解答。  
test: 隐藏测例，用于评测。  
example_test: 提示中出现的公开测例，用于评测。   

评测生成的代码需要使用多种语言编译、运行。我们使用的各编程语言依赖及所用包的版本如下：

|  依赖 | 版本  |
|  ----  | ----  |
|  Python  | 3.8.12  |
| JDK | 18.0.2.1 |
| Node.js | 16.14.0 |
| js-md5 | 0.7.3 |
| C++ | 11 |
| g++ | 7.5.0 |
| Boost | 1.71.0 |
| OpenSSL | 3.0.0 |
| go | 1.18.4 |
	


## 我们的工作

1、基于清华的HumanEval-X，进行了集成，修改了代码生成任务的结构；  
2、多模型配置，可以配置模型参数，以及是调取接口还是本地推理；  
3、优化了代码块方法体抽取的逻辑；  
4、目前适配了java、python、cpp、js和go等五种语言。


## 运行命令

下面是一个使用chatgpt来生成python语言测试数据的样例：
python main.py --task_type generate 
               --input_path eval_set/humaneval-x  
               --language_type python  
               --model_name chatgpt  
               --output_prefix output/humaneval  

评估样例：
python main.py --task_type evaluate 
               --language_type  python
               --input_path  output
               --tmp_dir  output/tmp/
               --n_workers  1
               --timeout 10.0  
               --problem_folder eval_set/humaneval-x/  
               --output_prefix output/
               --model_name chatgpt  

## 测试结果

受限于模型推理速度，目前只测试了pass@1指标。

|                      | python | java   | cpp    | js     | go     |
|----------------------|--------|--------|--------|--------|--------|
| chatgpt              | 64.02% | 42.68% | 26.22% | 47.00% | 31.70% |
| bbt-7B               | 0.61%  | 1.83%  | 1.22%  | 1.83%  | 0.00%  |
| bbt-13B              | 2.49%  | 0.00%  | 1.90%  | 1.83%  | 0.61%  |
| chatglm2-6B          | 7.93%  | 5.45%  | 0.61%  | 6.70%  | 1.83%  |
| codegeex2-6B         | 29.90% | 27.43% | 6.70%  | 24.40% | 17.68% |
| llama2-7B            | 5.49%  | 8.54%  | 1.22%  | 3.66%  | 6.10%  |
| baichuan-7B          | 7.93%  | 1.83%  | 0.00%  | 6.71%  | 6.71%  |
| chatgpt+codegeex2-6B | 64.02% | 43.90% | 30.49% | 50.66% | 44.51% |
| iflycode             | 46.95% | 29.87%  | 32.91% | 43.29% | 21.34%  |





## TODO
1、测试模型的pass@10和pass@100指标。  
2、代码翻译类任务还没有适配，同时也需要构造相关的数据。  
