const { defineConfig } = require('@vue/cli-service')
const path = require('path');
function resolve(dir){
  return path.join(__dirname,dir)//设置绝对路径
}
let publicPath = '/'
if (process.env.NODE_ENV === 'production') {
  publicPath = 'https://csdn.gitcode.host/csdn-datav/'
}
module.exports = defineConfig({
  assetsDir: 'csdn-datav',
  transpileDependencies: true,
  lintOnSave:false,
  publicPath:publicPath,
  devServer: {
    allowedHosts:'all',
    host: 'loc.csdn.net',
    headers: {
      'Access-Control-Allow-Origin': '*'
    }
  },
  // devServer: {
  //   allowedHosts:'all',
  //   port: '3000',
  //   headers: {
  //     'Access-Control-Allow-Origin': '*'
  //   }
  // },
  productionSourceMap: false,
  chainWebpack: config => {
    config.resolve.alias.set('@', resolve('src'))
  }
})
