
import {
  Message
} from 'element-ui'
let messageInstance = null
let time = ''
const resetMessage = (options) => {
  if (messageInstance) {
    messageInstance.close()
  }
  if (typeof options === 'string') {
    options = {
      message: options
    }
  }
  if (options.duration === 0) {
    time = 0
  } else if (options.duration === 5000) {
    time = 5000
  } else {
    time = 1500
  }
  messageInstance = Message({ ...options, duration: time })
  return messageInstance
}
;['error', 'success', 'info', 'warning'].forEach(type => {
  resetMessage[type] = options => {
    if (typeof options === 'string') {
      options = {
        message: options
      }
    }
    options.type = type
    return resetMessage(options)
  }
})
export default resetMessage
