# 开发文档

## 环境准备
#### git设置
* *注意*：设置git提交的user.email与[CSDN账号邮箱](https://i.csdn.net/#/user-center/account) 保持一致，避免个人真实信息泄露
```bash
# 大小写敏感
git config core.ignorecase false
# 设置你git提交用户名/邮箱，注意本项目尽量不要带--global
git config user.name "git用户名"
git config user.emall "git邮箱"
```

#### npm设置
本项目中的.npmrc 文件已经设置NPM国内镜像源，等同于以下配置
```bash
# 修改NPM国内镜像加速
npm config set registry https://registry.npmmirror.com/
```
#### 设置本地开发环境host
由于用户头像图片服务器设置了域名防盗链，所以本地环境需要在*.csdn.net 域名下访问，避免开发环境头像不显示问题
域名与与vue.config.js 配置保持一致
```
127.0.0.1 loc.csdn.net
```
云IDE环境注意做以下修改

1.找到vue.config.js 文件，修改devServer配置
```
    devServer: {
        allowedHosts:'all',
        port: '3000',
        headers: {
          'Access-Control-Allow-Origin': '*'
        }
    }
```
2.配置端口映射,将3000端口映射为平台支持的其他端口范围

3.通过云IDE的提供的在线调试地址访问


## 项目启动
```
npm install
```

### Compiles and hot-reloads for development
```
npm run serve
```

### Compiles and minifies for production
```
npm run build
```

### Lints and fixes files
```
npm run lint
```

### Customize configuration
See [Configuration Reference](https://cli.vuejs.org/config/).

