//  index.js 文件内容
import Vue from 'vue';
import VueRouter from 'vue-router';
import {isMobile} from "@/common/util"
//  定义路由, 创建路由配置项
const routes = [
    {
      path: '/',
      name: 'pcmap',
      component: () => import('./view/pc/home.vue'),
      beforeEnter (to, from, next) {
        if (!isMobile()) {
          next();
        } else {
          next({
            path:'/m' ,
           
          });
        }
      },
      children: [
        {
          path: '',
          redirect: 'force'
        },
        {
          path: 'force',
          component: () => import('./view/pc/force.vue'),
          meta: {
            title: '全网博主原力月度排名 - 开源实验室',
            navTitle:'原力排名',
            name:'全网博主原力月度排名',
            pageSpm: '1011.2266'
          }
        },
        {
          path: 'fans',
          component: () => import('./view/pc/fans.vue'),
          meta: {
            title: '全网博主铁粉排名 - 开源实验室',
            name:'全网博主铁粉排名',
            navTitle:'铁粉排名',
            pageSpm: '1011.2266'
          }
        },
      ]
    },
    {
      path: '/m',
      name: 'pcmap',
      component: () => import('./view/wap/home.vue'),
      beforeEnter (to, from, next) {
        if (isMobile()) {
          next();
        } else {
          next({
            path:'/' ,
          });
        }
      },
      children: [
        {
          path: '',
          redirect: 'force'
        },
        {
          path: 'force',
          component: () => import('./view/wap/force.vue'),
          meta: {
            title: '全网博主原力月度排名 - 开源实验室',
            navTitle:'原力排名',
            name:'全网博主原力月度排名',
            pageSpm: '1011.2266'
          }
        },
        {
          path: 'fans',
          component: () => import('./view/wap/fans.vue'),
          meta: {
            title: '全网博主铁粉排名 - 开源实验室',
            navTitle:'铁粉排名',
            name:'全网博主铁粉排名',
            pageSpm: '1011.2266'
          }
        },
      ]
    },  
]
Vue.use(VueRouter);
//  创建路由对象
const router = new VueRouter({
  base: `/csdn-datav`,
  mode: 'history',
  routes
})
router.beforeEach((to, from, next) => {
  if (to.meta.title) {
    document.title = to.meta.title
  }
  next()
})
//  把路由对象作为模块导出
export default router;
