import axios from 'axios'
let axiosSignature = axios.create()
initAxios(axiosSignature, true)
function initAxios (axiosObj, isNeedSignature = false) {
    // axios 配置
    axiosObj.defaults.timeout = 3000
    // http response 拦截器
    axiosObj.interceptors.response.use(
      response => {
        return response
      },
      error => {
        var errorMsg = ''
        if (error.response) {
          if (error.response.data && error.response.data.code && error.response.data.message) {
            errorMsg = error.response.data && error.response.data.code && error.response.data.message
            return Promise.reject(error.response.data)
          } else {
            errorMsg =
              error.response.status + ' ' + error.response.statusText || '系统异常,请稍后再试'
          }
        } else {
          errorMsg = '服务超时,请稍后重试'
        }
        let errorData = { code: 0, message: errorMsg }
        return Promise.reject(errorData)
      }
    )
  }
  export default axiosSignature