package com.example.bootdemo;

import java.util.Scanner;
import java.util.Stack;

public class ValidParentheses {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        String str = sc.nextLine();
        boolean isValid = isValid(str);
        System.out.println(isValid);
    }

    public static boolean isValid(String s) {
        if (s.length() % 2 == 1) { // 如果字符串长度为奇数则不可能完全匹配
            return false;
        }

        Stack<Character> stack = new Stack<>();

        for (char ch : s.toCharArray()) {
            if (ch == '(' || ch == '[' || ch == '{') { // 左括号入栈
                stack.push(ch);
            } else { // 右括号出栈
                if (stack.isEmpty()) { // 如果栈为空，则说明没有与该右括号匹配的左括号
                    return false;
                }

                char top = stack.peek(); // 获取栈顶元素

                if ((ch == ')' && top != '(') || (ch == ']' && top != '[') || (ch == '}' && top != '{')) { // 匹配检查
                    return false;
                }

                stack.pop();
            }
        }

        return stack.isEmpty(); // 栈内还有元素则说明不完全匹配
    }
}

