## 题目内容

题目不得违反国家政策与法律法规，不得出现敏感信息，不得出现强特征的个人、团体、机构等名称。

## 关于原题

原题大致可分为完全一致、几乎一致和做法一致三种。

<ul>
    <li>完全一致：使用一题的AC代码可以AC另一题</li>
    <li>几乎一致：由一题的 AC 代码改动至另一题的 AC 代码可以由一个不会该题的人完成。</li>
    <li>做法一致：核心思路、做法一致，但代码实现上、不那么关键的细节上有差异。。</li>
</ul>


这三种原题自下而上为包含关系。

以下情况不应出现：

<ol>
    <li>在明知有“几乎一致”的原题的情况下出原题。</li>
    <li>由于未使用搜索引擎查找导致自己不清楚有原题，从而出了“几乎一致”的原题。</li>
    <li>在“做法一致”的原题广为人知（如：NOIP、ACM区域赛、知名比赛网站的常规比赛轮次）时出原题。</li>
    <li>在带有选拔性的考试的非送分题中出现“做法一致”的原题。</li>
</ol>

以下情况最好不要出现：
<ol>
    <li>在明知有至少为“做法一致”的原题的情况下出原题。</li>
    <li>由于未使用搜索引擎查找导致自己不清楚有原题，从而出了“做法一致”的原题。</li>
    <li>在任何情况下出“几乎一致”的原题。</li>
</ol>


## 题面

### 题目背景

* 题面背景最好尽可能简短。如果题目背景比较长的时候，应当与题目描述分开

### 题目描述

* 要求**清晰易懂**

* 题面中的每个可能不被理解的定义都应得到解释，不应凭空冒出未加定义的概念。如："子序列"和"子串"的定义，对于一些概存在极限情况的概念也应做解释，如：一个点是否是一棵XX树。

* 题面中涉及到的每个概念应当使用单一的词汇来描述。如：不应一会儿说“费用”，一会儿说“代价“。

* 保证你的题面不会自相矛盾，保证题面不能被错误理解而自圆其说，即使这种理解是反常识、没有人会这么去想的。

* 顺着读题目描述应当能看懂每一句话，并理解题目的任务与要求。不能需要看了输入输出格式才能明白题意，甚至需要根据样例来猜题意。

* 同一题目的变量名大小写应该同一，不应出现在某处是NN,而在另一处变成nn的情况。同时建议变量与题目相关时使用小写，无关时（如数据组数TT）使用大写。

* 题目中的公式符号和数字都应用<em>LaTeXLaTeX</em>书写，

### 数据范围

* 数据范围都统一为写在输入格式里，数据范围中最容易犯的错误就是不完整。输入中的每一个数、每一个字符串都应该有清晰的界定。在上文所给出的输入输出格式示例中就有一些数据范围的正确写法。

* 数据类型（如整数、实数、字符等）应在输入格式中说明，数据范围应在说明/提示中说明。数据范围必须有上界和下界的描述，字符串必须有字符集的描述，实数必须有小数点后位数的描述。因此输入格式中不必说明「正整数」或「非负整数」而只需说明「整数」。

数据范围的常见遗漏：

<ol>
    <li>“整数”中的“整”。</li>
    <li>题面中只说了是“整数”没说是“正整数”，并且数据范围中只有上限没有下限。</li>
    <li>字符串没说字符集。</li>
    <li>实数没说小数点后位数。</li>
    <li>某些变量没有给范围。</li>
</ol>

你需要保证标程可以通过满足题面所述数据范围的任何一组数据。

### 样例

* 样例应当有一定的强度，能够查出一些简单的错误。读错题意的人应当能够通过样例发现自己读错了题意。
* 有多种操作的题，每种操作都应在样例中出现。有多种输出的题，每种可能的输出都应在样例中出现。
* 如果提供大样例，可以在**数据范围**处用 markdown 的链接指向一个剪贴板或网盘，而非直接简单地粘贴到样例里面。


### 样例说明

* 题目描述越复杂、越不易理解就越应当有详细的样例说明，题目难度越简单就越应当有详细的样例说明。一般来说，一道题**至少**应该有一个样例说明。


下面是一道样例题目的结构: 

```markdown
# {题目名称}

{题目描述}

## 输入描述

{输入描述}

## 输出描述

{输出描述}

## 输入样例

{输入样例}

## 输出样例

{输出样例}

## 提示

{提示}

```

以上 <code>{ }</code>中均是要填写的内容

其中, 输入样例输出样例不要填写任何多余的文本, 如: `结果是: 0`, 其中的: `结果是: `都是多余的内容.


一套完整的题目, 应至少包含四道题, 其中每个难度等级的题目数量如下:

```bash
简单: 1
中等: 2
困难: 1
```

以下是一套完整的题目的目录结构:

```bash
{{csdn}}
├── 中等
│   ├── {{示例2}}
│   │   ├── exercises.md
│   │   ├── solution.java
│   │   └── test_cases
│   │       ├── 1.in
│   │       ├── 1.out
│   │       ├── 10.in
│   │       ├── 10.out
│   │       ├── 2.in
│   │       ├── 2.out
│   │       ├── 3.in
│   │       ├── 3.out
│   │       ├── 4.in
│   │       ├── 4.out
│   │       ├── 5.in
│   │       ├── 5.out
│   │       ├── 6.in
│   │       ├── 6.out
│   │       ├── 7.in
│   │       ├── 7.out
│   │       ├── 8.in
│   │       ├── 8.out
│   │       ├── 9.in
│   │       └── 9.out
│   └── {{示例3}}
│       ├── exercises.md
│       ├── solution.java
│       └── test_cases
│           ├── 1.in
│           ├── 1.out
│           ├── 10.in
│           ├── 10.out
│           ├── 2.in
│           ├── 2.out
│           ├── 3.in
│           ├── 3.out
│           ├── 4.in
│           ├── 4.out
│           ├── 5.in
│           ├── 5.out
│           ├── 6.in
│           ├── 6.out
│           ├── 7.in
│           ├── 7.out
│           ├── 8.in
│           ├── 8.out
│           ├── 9.in
│           └── 9.out
├── 困难
│   └── {{示例4}}
│       ├── exercises.md
│       ├── solution.c
│       └── test_cases
│           ├── 1.in
│           ├── 1.out
│           ├── 10.in
│           ├── 10.out
│           ├── 2.in
│           ├── 2.out
│           ├── 3.in
│           ├── 3.out
│           ├── 4.in
│           ├── 4.out
│           ├── 5.in
│           ├── 5.out
│           ├── 6.in
│           ├── 6.out
│           ├── 7.in
│           ├── 7.out
│           ├── 8.in
│           ├── 8.out
│           ├── 9.in
│           └── 9.out
└── 简单
    └── {{示例1}}
        ├── exercies.md
        ├── solution.c
        └── test_cases
            ├── 1.in
            ├── 1.out
            ├── 10.in
            ├── 10.out
            ├── 2.in
            ├── 2.out
            ├── 3.in
            ├── 3.out
            ├── 4.in
            ├── 4.out
            ├── 5.in
            ├── 5.out
            ├── 6.in
            ├── 6.out
            ├── 7.in
            ├── 7.out
            ├── 8.in
            ├── 8.out
            ├── 9.in
            └── 9.out
```

每道题请至少提供十个测试用例

其中, <code>{{csdn}}</code>中的 `csdn` , 替换为题目的作者

<code>{{示例x}}</code>中的 `示例x` 替换为题目名称

`solution.x`为标程文件, 请至少提供一种编程语言的标程

**除标程的文件类型可以不一样外, 其他文件名及文件类型, 必须与题目目录文件结构中的文件名及文件类型一致**

仓库地址: [https://gitcode.net/csdn/contest_exercises_template](https://gitcode.net/csdn/contest_exercises_template)


## 联系我们

如果您有意愿参与出题，可扫码联系我们。

![](https://img-community.csdnimg.cn/images/268043ac9e3d45e8bd20efa054d20bb2.png)


最终解释权归CSDN所有。