#include <iostream>
#include <cstring>
#include <queue>
#include <climits>

using namespace std;

const int N = 1e3 + 10, M = 2e6 + 10;

int h[N], e[M], ne[M], w[M], idx;
int dist[N];
int n, m, k;
bool st[N]; // 

// ʼ
void init() {
  memset(h, -1, sizeof h);
  idx = 0;
}

// һ
void add(int a, int b, int c) {
  e[idx] = b, w[idx] = c, ne[idx] = h[a], h[a] = idx++;
}

// Dijkstra 㷨·
void dijkstra(int s) {
  memset(dist, 0x3f, sizeof dist);
  dist[s] = 0;

  priority_queue<pair<int, int>> q; // С
  q.push({0, s});

  while (q.size()) {
    auto t = q.top();
    q.pop();
    int ver = t.second, distance = t.first;
    if (st[ver]) continue;
    st[ver] = true;

    //  ver ڵĵ
    for (int i = h[ver]; ~i; i = ne[i]) {
      int j = e[i];
      if (dist[j] > distance + w[i]) {
        dist[j] = distance + w[i];
        q.push({dist[j], j});
      }
    }
  }
}

int main() {
  // 
  scanf("%d%d%d", &n, &m, &k);
  init();

  // ͼ
  while (m--) {
    int a, b, c;
    scanf("%d%d%d", &a, &b, &c);
    add(a, b, c);
  }

  // ·
  dijkstra(1);

  // ·
  printf("%d\n", dist[n]);

  return 0;
}
