#include <stdint.h>
#include <inttypes.h>
#include <vector>
#include <string>
#include <iostream>
#include <sstream>

class Range
{
public:
    Range():m_pos(0), m_length(0){};
    
    Range(uint64_t pos, uint64_t length): m_pos(pos), m_length(length){}
    
    Range(Range const & rhs){
        if (this == &rhs)
            return;
        m_pos = rhs.m_pos;
        m_length = rhs.m_length;
    }
    Range& operator = (Range const & rhs){
        if (this == &rhs)
            return *this;
        m_pos = rhs.m_pos;
        m_length = rhs.m_length;
        return *this;
    }

    ~Range(){}

    bool operator<(Range const & rhs) const{
        return m_pos < rhs.m_pos || (m_pos == rhs.m_pos && m_length < rhs.m_length);
    }

    uint64_t GetPos() const {
        return m_pos;
    }

    uint64_t GetLength() const{
        return m_length;
    }

    uint64_t GetRight() const{
        return m_pos+m_length;
    }

public:
    uint64_t m_pos;
    uint64_t m_length;
};

size_t findNatureRangeIndex(std::vector<Range>& rangeList, uint64_t point){
    size_t n = rangeList.size();
    size_t first = 0;
    size_t last = 2 * n + 1;
    size_t max = last;

    uint64_t testBeg = 0;
    uint64_t testEnd = 0;
    size_t idx = SIZE_MAX;
    while (first <= last) {
        size_t mid = (first + last) / 2;  // compute mid point.

        // 处理右边界
        if (mid >= max - 1) {
            uint64_t lastEnd = rangeList[n - 1].m_pos + rangeList[n - 1].m_length;
            if (point>=lastEnd) {
                idx = max - 1;
            } else {
                idx = max - 2;
            }
            break;
        }

        // 处理左边界
        if (mid == 0) {
            if (point >= rangeList[0].m_pos) {
                idx = 1;
            } else {
                idx = 0;
            }
            break;
        }

        // 处理中间
        bool even = mid % 2 == 0;
        if (even) {
            size_t left = (mid - 1) / 2;
            size_t right = left + 1;
            testBeg = rangeList[left].m_pos + rangeList[left].m_length;
            testEnd = rangeList[right].m_pos;
        } else {
            size_t current = mid / 2;
            testBeg = rangeList[current].m_pos;
            testEnd = rangeList[current].m_pos + rangeList[current].m_length;
        }

        // 二分查找
        
        if (point>=testEnd) {
            first = mid + 1;       // repeat search in top half.
        } else if (point<testBeg) {
            last = mid - 1;        // repeat search in bottom half.
        } else {
            idx = mid;
            break;
        }
    }

    return idx;
}

int main(int argc, char** argv){
    uint64_t p;
    int N;
    std::vector<uint64_t> inputs;

    // 输入点,区间个数
    std::cin>>p;
    std::cin>>N;

    // 收集区间点
    for(int i=0;i<N;i++){
        uint64_t l,r;
        std::cin>>l;
        std::cin>>r;
        inputs.push_back(l);
        inputs.push_back(r);
    }

    // 转换区间
    std::vector<Range> rangeList;
    for(int i=0;i<inputs.size();i+=2){
        Range range(inputs[i],inputs[i+1]-inputs[i]);
        rangeList.push_back(range);
    }

    // 查找
    size_t pos = findNatureRangeIndex(rangeList, p);
    std::cout<<pos;

    return 0;
}