from graphviz import Digraph

def draw_pf_algorithm_flow():
    dot = Digraph(comment='PF算法流程')

    # 开始节点
    dot.node('start', '开始', shape='oval')

    # 计算比值节点
    dot.node('calculate_ratio', '每个用户计算瞬时传输速率与长期平均传输速率的比值', shape='box')

    # 判断比值计算完成
    dot.node('judge_ratio', '是否完成所有用户比值计算', shape='diamond')

    # 排序节点
    dot.node('sort_users', '按照比值排序用户', shape='box')

    # 分配资源节点
    dot.node('allocate_resource', '依次为用户分配资源', shape='box')

    # 判断资源分配完成
    dot.node('judge_allocate', '是否完成所有用户资源分配', shape='diamond')

    # 结束节点
    dot.node('end', '结束', shape='oval')

    # 节点连接
    dot.edges([('start', 'calculate_ratio'), ('calculate_ratio', 'judge_ratio'), ('judge_ratio', 'calculate_ratio', '否'),
               ('judge_ratio','sort_users', '是'), ('sort_users', 'allocate_resource'), ('allocate_resource', 'judge_allocate'),
               ('judge_allocate', 'allocate_resource', '否'), ('judge_allocate', 'end', '是')])

    dot.render('pf_algorithm_flow.png', view=True)

if __name__ == "__main__":
    draw_pf_algorithm_flow()