# 子组织[](#子组织 "Permalink")

我们可支持20+ 层级的子组织（也称为嵌套结构或层次结构）。

通过子组织您可以：

*   **独立的子组织** 由于每个组都有自己的可见性级别，因此您可以在同一保护范围内创建不同子组织以满足您不同的使用目的；
*   **组织大型项目** 对于大型项目，子组织可能会更容易分隔源代码的权限
*   **使管理人员和控制可见性变得更加容易** 根据人们的组织[成员身份](#成员身份)赋予他们不同的[权限](/docs/user/permissions#组织成员权限) 

有关组织和项目中允许的权限的更多信息，请参考[可见性级别](/docs/user/permissions#general-permissions) 。

## 概览[](#概览 "Permalink")

一个组织中可以有许多子组织，且每个组织只能有一个直接父组， 它类似于目录或嵌套项目列表：

*   第一组
    *   1.1 组
    *   1.2 组
        *   1.2.1 组
        *   1.2.2 组
            *   1.2.2.1组

假设维护一个 GNU / Linux 发行版，其中第一个子组织是发行版的名称，随后的子组织则按如下所示拆分：

*   Organization Group - GNU/Linux distro
    *   类别子组-包
        *   （项目）配套 01
        *   （项目）配套 02
    *   类别子组-软件
        *   （项目）核心
        *   （项目）CLI
        *   （项目）Android 应用
        *   （项目）iOS 应用
    *   类别子组-红外线工具
        *   （项目）Ansible 剧本

当执行诸如在子组织之间转移或导入项目的操作时，其行为与在`group/project`级别执行这些操作时的行为相同。

## 新建一个子组织[](#新建一个子组织 "Permalink")

要在组织中创建子组织，您必须是该组织的所有者或维护者，具体取决于该组织的设置（默认情况下，允许所有者和维护者创建子组）。

有关权限的更多信息，请检查[权限表](/docs/user/permissions) 。有关不允许用作组名的单词列表，请参见[保留名称](/docs/user/reserved) 。

如果用户明确地作为所有者（或维护者，如果启用了此设置）被添加到父组织中，则用户始终可以创建子组，即使管理员在其组织设置中禁用了组创建也是如此。

您可以通过以下操作创建一个子组织：

1.  在组织详情页中，展开右上角**新建项目**旁的下拉按钮，选择**新建子组织** ，然后单击 **新建子组**按钮；
    
2.  像平常一样直接创建一个新组织。 需要注意的是，父组织名称空间在 **组路径**下是不可修改的，但 可见性级别可以与父组织不同；

3.  单击**创建组织**按钮


## 成员身份[](#成员身份 "Permalink")

将成员添加到子组织时，它们将从父组织继承成员资格和权限级别。如果您是其父组织成员之一，则您可以被允许访问该组织下所有的子组织。

成员的组权限只能由所有者更改，您可以通过查看组织的**组织设置-组织成员设置**页面来确定成员是否从父组织继承了权限。

[![Group members page](/docs/img/group_members.png)](/docs/img/group_members.png)

从上图我们可以了解到：

*   有 5 位成员可以访问第`four`组.
*   User0 是一个 Reporter，已从组`four`的层次结构上方的组`one`继承了该权限
*   User1 是一个开发者，已从组`one/two`的层次结构上方的组`two`继承了该权限
*   User2 是一个开发者，已从组`one/two/three`的层次结构上方的组`three`继承了该权限
*   对于 User3，没有任何父组织的指示，因此它属于`four`组
*   管理员是**所有**子组织的所有者和成员，与 User3 一样也没有任何父组织的指示

您可以使用右侧的下拉列表过滤此列表：

*   **仅显示直接成员**仅显示 Administrator 和 User3，因为这是属于`four`组的唯一用户
*   **仅显示继承的成员**将显示 User0，User1 和 User2，无论层次结构上方的哪个组都可以作为继承权限的来源

## 提及子组织[](#提及子组织 "Permalink")

在Issue，提交和合并请求中提及组织（ `@group` ）将通知该组的所有成员。当有了子组织后，如果您想拆分组织的结构，将有更精细的支持。提及方式与以前一样，您可以选择要通知的人群。