# 帮助文档

## 概览[](#概览 "Permalink")

欢迎您使用CODE CHINA，如果您是 Github 或 GitLab 的初级用户，我们建议您从查看本文档开始学习如何使用 CODE CHINA。如果您熟悉以上两个产品中的一个或多个，您可以直接开始 CODE CHINA 产品，在产品中我们也会为您设置帮助提示，您可以随时回来查看我们的产品文档。

| 基础入门 | 基本入门 |
| --- | --- |
| [**用户文件**](/docs/user)熟悉CODE CHINA 中的功能和概念. |[**是 Git 和 GitLab/GitHub 的新手吗？**](#刚开始使用gitcodechinagitlabgithub)我们有资源可以帮助您入门 |
| [**为 CODE CHINA 做贡献**](#为codechina开源做贡献)为CODE CHINA开源贡献力量！ | [**从另一个平台进入 CODE CHINA？**](#从另一个平台进入到-codechina)请查阅我们的便捷指南 |


## 热门话题[](#热门话题 "Permalink")

以下是我们推荐的一些主题：

### 计划[](#计划 "Permalink")

无论您使用 Waterfall，敏捷还是会话开发，CODE CHINA 均可简化您的协作工作流程。

使用 CODE CHINA 灵活的项目管理工具可视化，确定优先级，协调和跟踪进度。

以下文档与 DevOps **计划**阶段有关：

| 计划主题 | 描述 |
| --- | --- |
| Burndown Charts| 在特定的里程碑中观察项目的进度 |
| [讨论](/docs/user/discussions) | 问题，提交和合并请求中的线程，注释和可解决线程 |
| [截止日期](/docs/user/project/issues/due-date) | 跟踪发行期限|
| Epics | 跟踪共享主题的问题组|
| [ Issue ](/docs/user/project/issues) ，包括[机密问题](/docs/user/project/issues/confidential) ，[发布和合并请求模板](/docs/user/project/description-template) ，和[移动问题](/docs/user/project/issues/manage#移动-issue) | 项目问题并限制对问题的访问，并创建用于提交新问题和合并请求的模板。 此外，还可在项目之间转移问题|
| [标签](/docs/user/project/label) | 分类问题或使用描述性标签合并请求|
| [里程碑](/docs/user/project/milestone) | 设置发布问题和合并请求的里程碑，并带有可选的截止日期|
| [看板](/docs/user/project/kanban) | 在 Scrum 或看板上显示问题|
| [快捷方式](/docs/user/shortcutkey) | 针对问题或合并请求的常见操作的快捷方式，而无需单击按钮或在WEB界面中使用下拉菜单 |
| [关联 Issue](/docs/user/project/issues/crosslinking) | 在问题之间建立关系 |
| Roadmap | 可视化史诗般的时间表 |
| [时间跟踪](/docs/user/project/time-track) | 跟踪花费在问题和合并请求上的时间 |
| [待办事项](/docs/user/todo) | 通过在简单仪表板上显示的时间顺序列表，跟踪需要注意的工作 |

[返回概览](#概览)

### 新建[](#新建 "Permalink")

将源代码整合到一个易于管理和控制的[分布式版本控制系统中](https://en.wikipedia.org/wiki/Distributed_version_control) ，而不会中断您的工作流程。

CODE CHINA 存储库随附分支工具和访问控制，可为项目和代码的协作提供可扩展的单一事实来源。

以下文档与 DevOps **新建**阶段有关：

#### 项目和组织[](#项目和组织 "Permalink")

| 创建主题-项目和组 | 描述 |
| --- | --- |
| 全局搜索 | 利用 Elasticsearch 在整个 CODE CHINA 实例上进行更快，更高级的代码搜索|
| 语法检索 | 使用高级查询获得更具针对性的搜索结果|
| Contribution analytics | 请参阅小组贡献者的详细统计信息|
| [创建](/docs/basic/create-project)并 fork 项目，以及[导入项目](/docs/user/project/import) | 创建，复制和移动项目 |
| 锁定文件 | 锁定文件以避免合并冲突 |
| [组织](/docs/user/org) and [子组织](/docs/user/org/sub_org) | 分组组织您的项目 |
| Issue 分析 | 检查每月创建了多少个问题|
| [项目](/docs/user/project) ，包括项目访问和[设置](/docs/user/project/settings) | 托管源代码，并控制项目的可见性和设置配置。|
| [搜索](/docs/img/add_user_search_people.png) | 搜索问题，合并请求，项目，组和待办事项。|
| [Web IDE](/docs/user/project/webide) | 在 WebIDE 中编辑文件|
| [Wikis](/docs/user/project/wiki) | 使用内置的 Wiki 来管理您的文档|

[返回概览](#概览)

#### 代码仓库[](#代码仓库 "Permalink")

| 创建主题-代码仓库 | 描述 |
| --- | --- |
| [分支](/docs/user/project/repo/branches)和[默认分支](/docs/user/project/repo/branches#默认分支) | 如何在 CODE CHINA 中使用分支 |
| [提交](/docs/user/project/repo#提交) and [署名提交](/docs/user/project/repo/gpg-sign) | 处理提交，并使用 GPG 对您的提交进行签名 |
| [创建分支](/docs/user/project/repo/web-editor#新建分支) ， [创建](/docs/user/project/repo/web-editor#创建文件)并[上传](/docs/user/project/repo/web-editor#上传文件)文件，并[创建目录](/docs/user/project/repo/web-editor#新建目录) | 创建分支，创建和上传文件以及创建目录|
| [删除已合并的分支](/docs/user/project/repo/branches#删除已合并的分支) | 合并更改后的批量删除分支|
| [文件模板](/docs/user/project/repo/web-editor#文件模板) | 通用文件的文件模板 |
| [文件](/docs/user/project/repo#文件) | 文件管理 |
| Jupyter Notebook 文件 | 对`.ipynb`文件的支持 |
| [保护分支](/docs/user/project/protected-branch) | 使用受保护的分支 |
| 推送规则| 对项目推送的附加控制 |
| [代码仓库](/docs/user/project/repo) | 在网页中管理源代码仓库 |
| 镜像代码仓库 | 推入或拉出外部的代码仓库 |
| [处理合并请求](/docs/user/project/repo/web-editor#提示) | 在提交时启动合并请求 |

[返回概览](#概览)

#### 合并请求[](#合并请求 "Permalink")

| 创建主题-合并请求 | 描述 |
| --- | --- |
| 在本地处理合并请求 | 在本地处理合并请求的提示|
| [Cherry-pick](/docs/user/project/merge-request/cherry-pick) | 对更改进行 Cherry Pick |
| [Merge request thread resolution](/docs/user/discussions#将单个讨论转变成-issue) | 解析线程，将合并请求中的线程移至问题，并且仅在解决所有线程后才允许合并请求 |
| [合并请求](/docs/user/project/merge-request) | 合并请求管理 |
| [草稿合并请求](/docs/user/project/merge-request/draft) | 防止合并草稿合并请求 |

[返回概览](#概览)


## 刚开始使用Git/CODE CHINA/GitLab/Github？[](#刚开始使用git吗 "Permalink")

使用新系统可能让您觉得难以入手，我们有以下文档可快速提升您的相关知识：

| 主题 | 描述 |
| --- | --- |
| Basics guides | 开始在命令行和 CODE CHINA 上工作 |
| Workflow overview | 利用最佳的工作流程增强您的工作流程 |
| [Markdown](/docs/user/markdown) | 高级格式化系统（Markdown） |

[返回概览](#概览)

### 账户管理[](#账户管理 "Permalink")

了解有关帐户管理的更多信息：

| 主题 | 描述 |
| --- | --- |
| [用户账号](/docs/user/account) | 管理您的帐户 |
| 账号验证 | 设置您的 SSH 密钥，并部署密钥以安全地访问您的项目 |
| [用户权限](/docs/user/permissions) | 了解项目中的每个角色可以做什么 |

[返回概览](#概览)

### Git 和 CODE CHINA[](#Git和CODE CHINA "Permalink")

了解有关使用 Git 以及将 Git 与 CODE CHINA 结合使用的更多信息：

| 主题 | 描述 |
| --- | --- |
| Git | Git 入门，分支策略，Git LFS 和高级用法 |
| [Git cheat sheet](https://about.gitlab.com/images/press/git-cheat-sheet.pdf) | 下载描述最常用的 Git 操作的 PDF|
| Work Flow| 使用 Work Flow 策略探索 Git 的精华 |

[返回概览](#概览)

## 从另一个平台进入到 CODE CHINA？[](#从另一个平台进入到codechina "Permalink")

如果您是从另一个平台进入 CODE CHINA，您会发现以下有用信息：

| 主题 | 描述 |
| --- | --- |
| [导入项目](/docs/user/project/import) | 从 GitHub 和 SVN 导入项目 |
| 从SVN迁移 | 将 SVN 存储库转换为 Git 和 CODE CHINA |

[返回概览](#概览)


## 为CODE CHINA开源做贡献[](#为codehina开源做贡献 "Permalink")

CODE CHINA 是开源的，您可以通过以下方式为我们的开源社区做出贡献：


| 主题 | 描述 |
| --- | --- |
| 开发 | 如何在开发上做贡献 |
| 协议 | 贡献者许可协议 |
| 文档 | 如何在文档上做贡献|

[返回概览](#概览)