---
title: "测试技术初阶"
date: 2018-12-29
lastmod: 2020-01-05
weight: 1
type: docs
icon: #
description: "初阶路线图"
# search related keywords
---


![高校俱乐部](https://codechina.csdn.net/codechina/operation-work/uploads/53b24f5f44d3c851890b1789ed501001/%E9%AB%98%E6%A0%A1%E4%BF%B1%E4%B9%90%E9%83%A8320.jpg)

<p style="text-align:center;font-weight:bold;">关注“高校俱乐部”微信公众号，回复“路线图”，快人一步获取高清全套技术路线图</p>

<br>


{{< embed-pdf-view url="/images/test.pdf" >}}

### 测试用例设计

- 黑盒测试用例
  - 等价类
  - 边界值
  - 因果图
  - 判定表
  - 正交试验
  - 场景分析
  - 状态图
  - 错误推断
- 白盒测试用例
  - 语句覆盖
  - 判定覆盖
  - 条件覆盖
  - 条件/判定覆盖
  - 条件组合覆盖
  - 修正判定条件覆盖
  - 点覆盖
  - 边覆盖
  - 路径覆盖

### 基础体验评测

- 功能体验
  - 完备性
  - 准确性
  - 易用性
  - 易学性
  - 展示样式
  - 任务路径
  - 竞手对比
  - 兼容性
- 性能体验
  - 客户端性能
    - 安装、启动类
    - GPU绘制类
    - 时间类
    - 帧率类
    - 稳定性
    - 系统性能（CPU/内存）
    - 弱网
    - 流量
    - 耗电量
  - 服务端性能
    - 影响时间
    - 并发量
    - TPR
    - TPS
    - MO
    - IO
    - 稳定性
    - 系统性能
    - 全链路

### 通用测试工具

- 客户端工具
  - Postman
  - Fiddler
  - Charles
  - Wireshark
  - 云测平台
- 服务端工具
  - LoadRunner
  - JMeter
  - Silk Performer
  - 云压测

### 自动化工具

- UI自动化
  - Selenium
  - WebDriver
  - UI Automator
  - Appium
  - PhantomJS
  - Sahi
- 接口自动化
  - JMeter
  - HttpRunner

### 管理工具

- 需求/用例/缺陷
  - QC
  - TestLink
  - iCase
  - Bugzilla
  - 禅道
  - 飞蛾
  - Jira
- 代码管理
    - Git
    - SVN


## 相关学习资源

1. [Fillder 使用手册-百度经验](https://jingyan.baidu.com/article/d8072ac4812124ec94cefd49.html)
2. [Charles 官网](http://www.charlesproxy.cn/Index.html)
3. [Charles 使用介绍](https://www.jianshu.com/p/fc2f0afa8b56)
4. [wireshark 官方使用手册](https://www.wireshark.org/docs/wsug_html_chunked/)
5. [Jmeter 官方手册](https://jmeter.apache.org/usermanual/)
6. [Selenium 官方文档](https://www.selenium.dev/selenium/docs/api/py/api.html)
7. [uiautomator 文档](https://developer.android.google.cn/training/testing/ui-automator)
8. [uiautomator API介绍](https://developer.android.google.cn/reference/androidx/test/uiautomator/package-summary)
9. [appium 官方介绍](http://appium.io/docs/en/about-appium/intro/)
10. [phantomJS API](https://phantomjs.org/api/)
11. [sahi 使用文档](https://sahipro.com/docs/introduction/index.html)
12. [httprunner 使用手册](https://docs.httprunner.org/)
13. [Testlink 中文介绍](http://www.testlink.org.cn/509.html)
14. [Jira 使用手册](https://www.atlassian.com/zh/software/jira/guides)
15. [SVN 官方链接](https://tortoisesvn.net/)
16. [git 官方链接](https://git-scm.com/)
17. [git 教程](https://www.runoob.com/git/git-tutorial.html)
