# Contributing

整理 《IT技术知识开源图谱》项目是一个巨大的工程，我们希望你能够参与到这个开源项目中来，通过你的努力和贡献来修正和完善《IT技术知识开源图谱》，给开发者提供更好的学习资源。

你可以通过提交 Issue 和 Merge Request 的方式来参与本项目，你可以为每个路线图补充/提供知识点、学习资料，你甚至可以发起一个你感兴趣的领域路线图，通过开源的方式让大家一起来完善它。

# 社区治理

《IT技术知识开源图谱》社区由 编辑 + 专家 组成，其中编辑是由项目发起方 CODE CHINA 指定的，专家是由参与到路线图中的各个技术专家组成。

**编辑** - Maintainer

编辑：编辑作为整个项目的 maintainer，负责整个《IT技术知识开源图谱》项目的日常维护工作，包括但不限于：

- 项目的 Issue 处理
- 更新维护图谱项目
- 邀请/添加专家

> 注：编辑由项目发起方 CODE CHINA 指定，暂不接受社区成员申请。

**专家组** - Developer

专家组：专家组作为整个项目的 co-member，负责某个/某几个《IT技术知识开源图谱》项目的内容建设，包括但不限于：

- 特定路线图项目的 Issue 处理
- 查看并 Review 特定路线图中的 Merge Request
- 参与专家组新成员投票，决定社区成员从 Reporter 提升为 Developer

> 注：专家组成员至少需要在一个路线图中提交过 Merge Request 并被接受合并到主分支

**社区成员** - Reporter

社区成员：社区成员指所有为《IT技术知识开源图谱》项目做出过贡献的用户，贡献内容不限于：

1. 通过 Issue 提交新的知识点
2. 通过 Issue 补充知识点的学习资料
3. 通过 Merge Request 提交新的知识点
4. 通过 Merge Request 补充知识点的学习资料
5. 通过 Merge Request 优化路线图知识结构
6. 通过 Issue / Merge Request 发起新的路线图

> 注：社区成员至少需要在一个路线图中提交过 Merge Request 并被接受合并到主分支，且在专家组新成员投票中获得 50% 以上的赞同票才可以提升专家组成员
## 常见问题

> **1. 现在都有哪些路线图？**

答：目前我们已经发起了**前端**、**后端**、**DevOps**等13个路线图，你可以在下方或《IT技术知识开源图谱》 Pages 中查看到全部路线图的信息，路线图也会持续更新：

- [前端](https://codechina.gitcode.host/developer-roadmap/frontend/intro/)
- [后端](https://codechina.gitcode.host/developer-roadmap/backend/intro/)
- [Devops](https://codechina.gitcode.host/developer-roadmap/devops/intro/)
- [测试](https://codechina.gitcode.host/developer-roadmap/text/intro/)
- [安全](https://codechina.gitcode.host/developer-roadmap/security/intro/)
- [云原生](https://codechina.gitcode.host/developer-roadmap/cloud-native/intro/)
- [AI](https://codechina.gitcode.host/developer-roadmap/ai/intro/)
- [音视频](https://codechina.gitcode.host/developer-roadmap/av/intro/)
- [区块链](https://codechina.gitcode.host/developer-roadmap/blockchain/intro/)
- [鸿蒙OS](https://codechina.gitcode.host/developer-roadmap/harmonyos/intro/)
- [Python](https://codechina.gitcode.host/developer-roadmap/python/intro/)
- [Go](https://codechina.gitcode.host/developer-roadmap/go/intro/)
- [Rust](https://codechina.gitcode.host/developer-roadmap/rust/intro/)
- 持续更新中…

> **2. 我怎么通过提交 Issue 来贡献内容？**

答：如果你正好之前写过某个路线图中知识点相关的内容（博客文章、代码项目、代码片等），又或者你在学习过程中找到过一些非常不错的学习资料，并且你认为会对其他开发者学习该路线图中的内容有所帮助，你就可以通过 Issue 来进行提交。

我们在每个学习路线图中都创建了一个 Issue 模板用来指导你如何提交相应的内容，按照 Issue 模板中的内容提交即可，以下是 Python 项目中的 Issue 模板示例：

```markdown
## 贡献类型

- [x] 补充学习资料
- [ ] 补充知识点

> 填写说明：在对应类型的中括号/方括号中填上`x` 即可

## 所属知识点

- Python 中阶
    - Web 应用开发
        - Web 开发基础知识

> 填写说明： 初阶/中阶/高阶 >> 一级知识点 >> 二级知识点 （依次类推）

## 补充内容

- [Web前端基础知识整理（一）](https://blog.csdn.net/hxy19971101/article/details/93383336)
- [Web前端基础知识整理（二）](https://blog.csdn.net/hxy19971101/article/details/93383336)

> 填写说明：填写补充知识点的名称或学习资料名称+链接，如果有多个知识点或学习资料补充，在补充内容中依次提交即可
```

> **3. 我怎么通过提交 Merge Request 来贡献内容？**

答：除了 Issue 的方式外，你也可以通过 Merge Request(合并请求) 的方式来向我们提交新的知识点、补充学习资料，你甚至可以调整/优化学习路线图中的知识点结构，帮助开发者更好的理解路线图中的内容。

像我们提交 Merge Request 的方式，你需要：

1. Fork 某个学习路线项目
2. 在 Fork 的项目中进行调整，可以是提交新的知识点、补充学习资料、调整/优化知识结构等
3. 提交更新，并向源仓库发起 Merge Request(合并请求)

更多关于 Merge Request(合并请求) 的内容请参考 [从 Fork 项目创建合并请求](https://codechina.csdn.net/codechina/help-docs/-/wikis/docs/user/project/merge-request/create-merge-request#%E4%BB%8E-fork-%E9%A1%B9%E7%9B%AE%E6%96%B0%E5%BB%BA%E5%90%88%E5%B9%B6%E8%AF%B7%E6%B1%82)

> **4. 我怎么发起一个新的路线图？**

答：如果你想发起一个新的路线图，请参考目前已经发起的路线图项目，整理好路线图中的知识点、学习资料，并在当前项目中通过提交 Issue 或 Merge Request(合并请求) 的方式告知我们。


**我们会尽快处理你提交的 Issue 或 Merge Request，如果需要帮助请联系【周翔 E-mail：zhouxiang@csdn.net】。**


## 为什么一定要贡献代码（内容）？

贡献代码（内容）可以避免你碰到以下麻烦：

1.你在《IT技术知识开源图谱》上更改的代码（内容）其他人看不到，不能帮你发现 Bug，更不可能帮你修复 Bug 甚至优化代码（内容）
2.作者和其它贡献者可能不兼容你更改的代码（内容），导致你的项目在迭代 《IT技术知识开源图谱》 版本后在内容上出错
3.你需要自己维护你的代码（内容），每次迭代 《IT技术知识开源图谱》版本时，你都需要下载《IT技术知识开源图谱》 新代码（内容）再合并你自己的更改

所以为了让你自己的更改始终能跟上项目版本，得到他人给予的可靠且持续的维护，强烈建议 提交 Merge Request 来贡献代码（内容）。


## 开源版使用须知

1.允许用于个人学习、毕业设计、教学案例、公益事业
2.如果商用必须保留版权信息，请自觉遵守
3.禁止将本项目的代码和资源进行任何形式的出售，产生的一切任何后果责任由侵权者自负


## 版权风险

不得发布未经个人/机构授权的著作 、资料、教程等造成版权侵权。包含但不限于以下场景：
- 标题/内容 带有软件破解含义，讲解破解流程等、提供破解工具等；
- 发布未经他人授权书籍目录、内容、相关资料、源码、下载链接等；
- 发布未经其他网站/机构授权的 资料、教程 、影评、剧透等；
- 发布 爬取付费内容、个人隐私、国家级网站内容等。


## 版权和许可证

《IT技术知识开源图谱》由知识共享-署名-非商业性-相同方式共享(CC-BY-NC-SA) LICENSE 提供