# 项目背景

本项目是CSDN在编辑部协同IT领域具有技术影响力的知名企业和专家，共同打造的13个当前热门技术领域的技术知识点及相关学习资源，最终CSDN编辑进行了编辑汇总，最终制作成13张知识图谱及成长路线。通过这些知识图谱绘和成长路线，我们不难发现，作为一名IT工程师是多么不易，要面对日积月累的新技术，每门新技术都需要掌握规模庞大的知识点。

# 项目目的

本着**开源精神**， 我们决定把此项目开源， 以达到以下目的：

1. 让更多的工程师通过一张图看到他所在的技术领域的视觉全貌， 享受并热爱自己的技术领域
2. 让更多的专家、IT工程师能在相关的知识点下，贡献更多的学习资源，以便大家系统化的学习，甚至相互交流
3. 产生更多的技术领域的只是图谱和进阶路线，与万千技术人共成长。


本项目旨在大家一起贡献，一起学习，所有的贡献者都会作为出品人记录在案，欢迎大家一起贡献，具体贡献规则见[如何贡献](CONTRIBUTING.md)

# 技术专家

爱奇艺测试技术委员会：梅倩、于庆、奚燕、段梅姣、张蕾、白凤伟、吴甜甜、李博、仇亚颖、严远

吴洋 Testin云测高级项目总监、创新实验室负责人

# 环境准备

本仓库基于 `HUGO` 模板搭建，可以在本地直接运行该项目，你可以通过以下命令安装 `HUGO`环境：

1. 安装 `HUGO`

```bash
# 通过 homebrew 安装(macOS / Linux) 
brew install hugo
# 通过 MacPorts 安装(macOS) 
port install hugo
# 通过 Chocolatey 安装(Windows)
choco install hugo -confirm
# 安装 Sass/SCSS 增强版 HUGO (Windows)
choco install hugo-extended -confirm
```

更多关于`HUGO`的安装内容可以参考[HUGO 官方文档](https://gohugo.io/getting-started/installing/)

2. 安装完成后可以通过 `hugo version` 确认是否安装成功

```bash
➜  ~ hugo version
Hugo Static Site Generator v0.78.0-FD62817B/extended darwin/amd64 BuildDate: 2020-11-03T13:20:38Z
```
## 目录结构

本仓库目录结构如下：

```
-- .gitlab
 |-- issue_templates
 |-- merge_request_templates
-- archetypes
-- content
 |-- junior
 |-- intermediate
 |-- senior
-- data
-- layout
-- resources
-- static
 |-- images
-- themes
 |-- dot
 |-- hugo-theme-pdf-js
-- config.toml
-- CONTRIBUTING.md
-- README.md
```

### 内容部分说明

 `content` 为 Markdown 格式内容部分，`junior`,`intermediate`,`senior`分别对应 初阶、中阶、高阶部分的内容

#### _index.md 说明

每个目录下会有一个 `_index.md` 文件，用于描述每个部分的内容，其中`type`,`weight`这2个参数说明如下：

- `type`,`_index.md`的 `type` 需要设置为 `docs`，这样才能在首页显示
- `weight`, `weight`用于控制`type`都为`docs`的排序，即`junior`,`intermediate`,`senior`三者的排序

#### *.md 说明

除 `_index.md` 外，其余的 markdown 文件均不需要配置 `type` 参数，但仍需要配置 `weight` 参数，用于同一目录下的 md 内容排序。

markdown 内容的建议规则如下：

- 每个 markdown 文件是一个一级知识点
- 二级知识点、三级知识点在 markdown 中用列表的形式展开
- 如果有相应的学习资料，可以放在每个知识点的 markdown 中；也可以将所有知识点单独作为最后一个 markdown 内容单独呈现


### config.toml 配置说明

`config.toml` 是 `HUGO`  项目的配置文件，相关参数说明如下：

- `baseURL` 是项目在 Pages 服务器上的存放目录
- `title` 是项目的 Title
- `primary_color` 是项目的 主色调

更详细的介绍请参考 [HUGO 模板使用](https://codechina.csdn.net/codechina/help-docs/-/wikis/docs/user/project/pages/hugo)

## 本地运行项目

在完成 **环境准备** 以及熟悉 **目录结构** 后，你可以开始在本地运行该项目，并可以实时在本地预览编辑、修改。

### build 项目

在项目目录下运行 `hugo serve -D` 即可

```bash
➜  ~ cd intro
➜  ~ hugo serve -D
Start building sites …

                   | ZH
-------------------+-----
  Pages            | 28
  Paginator pages  |  0
  Non-page files   |  0
  Static files     |  4
  Processed images |  0
  Aliases          |  6
  Sitemaps         |  1
  Cleaned          |  0

Built in 42 ms
Watching for changes in ~/intro/{archetypes,content,data,layouts,static,themes}
Watching for config changes in ~/intro/config.toml
Environment: "development"
Serving pages from memory
Running in Fast Render Mode. For full rebuilds on change: hugo server --disableFastRender
Web Server is available at http://localhost:1313/ (bind address 127.0.0.1)
Press Ctrl+C to stop
```

运行完成后即可访问 `http://localhost:1313/` 实时预览当前项目