---
title: "安全技术高阶"
date: 2018-12-29
lastmod: 2020-01-05
weight: 3
type: docs
icon: #
description: "高阶路线图"
# search related keywords
---


![高校俱乐部](https://codechina.csdn.net/codechina/operation-work/uploads/53b24f5f44d3c851890b1789ed501001/%E9%AB%98%E6%A0%A1%E4%BF%B1%E4%B9%90%E9%83%A8320.jpg)

<p style="text-align:center;font-weight:bold;">关注“高校俱乐部”微信公众号，回复“路线图”，快人一步获取高清全套技术路线图</p>

<br>


{{< embed-pdf-view url="/images/test.pdf" >}}



### 灾备演练

- 高可用架构
  - 高可用存储
    - 主从
    - 分区
    - 读写分离
  - 业务高可用
    - 异地多活
  - 接口高可用
    - 限流
    - 降级
    - 熔断
    - 排队
- 故障注入
  - 单机故障
    - CPU压力注入
    - 内存压力注入
    - 磁盘压力注入
    - 网卡故障注入
    - 进程故障注入
  - 系统级故障
    - 系统单点故障
    - 依赖超时/异常
    - 异步阻塞
    - 数据库宕机
    - 数据库同步延迟
    - 数据库主备延迟
    - 数据库连接满
    - 流量超载
  - 网络故障
    - 抖动、丢包、超时
    - DNS故障
    - 断网

### 安全测试

- 代码扫描
  - CodeSecure
  - Checkmarx
  - Fortify
- Web漏洞扫描
  - WebScarab
  - AppScan
  - Burp Suite
  - AWVS(Acunetix Web Vulnerability Scanner)
  - Nikto
- APP漏洞扫描
  - AppSpider
  - AppScan
  - Nessus
  - Mobile Security Framework
- APP反编译
  - Android
    - Apktool
    - JEB
    - JADX
  - iOS反编译
    - IDA Pro
    - Hopper Disassembler
- SQL注入
  - SQLMap
  - jSQL Injection
  - BBQSQL
  - NoSQLMap
- 人工渗透
  - Metasploit Framework
  - Burp Suite
  - Empire
  - Cobalt Strike

### 集群化

- 容器
  - Docker
  - Docker镜像
  - Dockerfile
- 容器编排
  - Kubernetes
  - Docker Compose
  - Rancher
- 云服务
  - Saas
  - PaaS
  - IaaS

### 智能测试

- 智能测试框架
  - 深度学习
    - TensorFlow
    - PyTorch
    - Keras
  - 机器学习
    - Scikit-learn
- 智能测试算法
  - 监督学习
    - K-近邻算法
    - 决策树
    - 朴素贝叶斯
    - 逻辑回归
  - 无监督学习
    - 聚类算法
    - 降维算法
  - 强化学习
      - Q-learning
      - SARSA(State–action–reward–state–action)
      - DQN(Deep Q-Networks)
      - DDPG(Deep Deterministic Policy Gradient)


## 相关学习资源

1. [高可用架构（第1卷）](https://item.jd.com/12195481.html)
2. [Chaos Engineering](https://item.jd.com/10020883070676.html)
3. [从零开始学架构](https://item.jd.com/12450348.html)
4. [阿里巴巴故障注入工具](https://github.com/chaosblade-io/chaosblade/releases)
5. [TF官方文档](https://tensorflow.google.cn/learn)
6. [TF样例代码](https://github.com/aymericdamien/TensorFlow-Examples)
7. [PyTorch官方文档](https://pytorch.org/docs/stable/index.html)
8. [Keras学习范例](https://github.com/erhwenkuo/deep-learning-with-keras-notebooks)
9.  [Scikit-learn官网](https://scikit-learn.org/stable/)
10. [Sklearn快速入门教程](https://blog.csdn.net/linxid/article/details/79104130)
11. [监督学习](https://zh.wikipedia.org/wiki/监督学习)
12. [监督学习最常见的四种算法](https://blog.csdn.net/laobai1015/article/details/75006511)
13. [K近邻算法详解](https://blog.csdn.net/wangmumu321/article/details/78576916)
14. [决策树](https://blog.csdn.net/jiaoyangwm/article/details/79525237)
15. [逻辑回归-理论篇](https://blog.csdn.net/pakko/article/details/37878837)
16. [带你理解朴素贝叶斯算法](https://zhuanlan.zhihu.com/p/26262151)
17. [一文看懂无监督学习](https://easyai.tech/ai-definition/unsupervised-learning/)
18. [常见的6大聚类算法](https://blog.csdn.net/Katherine_hsr/article/details/79382249)
19. [12种降维方法终极指南](https://zhuanlan.zhihu.com/p/43225794)
20. [强化学习知识整理](https://zhuanlan.zhihu.com/p/25319023)
21. [Q-learning算法详解](https://blog.csdn.net/qq_30615903/article/details/80739243)
22. [强化学习-Sarsa](https://blog.csdn.net/winycg/article/details/79334771)
23. [DQN从入门到放弃](https://zhuanlan.zhihu.com/p/21262246?refer=intelligentunit)
24. [DDPG算法详解](https://blog.csdn.net/qq_30615903/article/details/80776715)