# 概览

[概览](intro.md)

# 目录

- [科学计算基础软件包NumPy](1.md)
  - [NumPy概述](2.md)
    - [NumPy的前世今生](3.md)
    - [NumPy数组 vs Python列表](4.md)
    - [NumPy数组类型和属性](5.md)
    - [维、轴、秩](6.md)
    - [广播和矢量化](7.md)
  - [安装配置](8.md)
  - [创建数组](9.md)
  - [操作数组](10.md)
    - [索引](11.md)
    - [切片](12.md)
    - [改变数组结构](13.md)
    - [合并和拆分](14.md)
    - [复制](15.md)
    - [排序](16.md)
    - [查找](17.md)
    - [筛选](18.md)
    - [数组I/O](19.md)
  - [常用函数](20.md)
    - [np.nan和np.inf](21.md)
    - [函数命名空间](22.md)
    - [数学函数](23.md)
    - [统计函数](24.md)
    - [插值函数](25.md)
    - [多项式拟合函数](26.md)
    - [自定义广播函数](27.md)
  - [掩码数组](28.md)
    - [创建掩码数组](29.md)
    - [访问掩码数组](30.md)
  - [矩阵对象](31.md)
    - [创建矩阵](32.md)
    - [矩阵特有属性](33.md)
    - [矩阵乘法](34.md)
  - [随机抽样子模块](35.md)
    - [随机数](36.md)
    - [随机抽样](37.md)
    - [正态分布](38.md)
    - [伪随机数的深度思考](39.md)
- [结构化数据分析工具Pandas](40.md)
  - [Pandas概览](41.md)
    - [Panda的特点](42.md)
    - [安装和使用](43.md)
  - [数据结构](44.md)
    - [索引数组Index](45.md)
    - [带标签的一维同构数组Series](46.md)
    - [带标签的二维异构表格DataFrame](47.md)
  - [基本操作](48.md)
    - [数据预览](49.md)
    - [数据选择](50.md)
    - [改变数据结构](51.md)
    - [改变数据类型](52.md)
    - [广播与矢量化运算](53.md)
    - [行列级广播函数](54.md)
  - [高级应用](55.md)
    - [分组](56.md)
    - [聚合](57.md)
    - [层次化索引](58.md)
    - [表级广播函数](59.md)
    - [日期时间索引对象](60.md)
    - [透视表](61.md)
    - [数据可视化](62.md)
    - [数据I/O](63.md)
- [绘图库Matplotlib](64.md)
  - [安装配置](65.md)
  - [Matplotlib快速入门](66.md)
    - [画布](67.md)
    - [子图与子图布局](68.md)
    - [坐标轴与刻度的名称](69.md)
    - [图例和文本标注](70.md)
    - [显示和保存](71.md)
  - [图形绘制](72.md)
    - [曲线图](73.md)
    - [散点图](74.md)
    - [直方图](75.md)
    - [饼图](76.md)
    - [箱线图](77.md)
    - [绘制图像](78.md)
    - [极坐标绘图](79.md)
  - [风格和样式](80.md)
    - [画布设置](81.md)
    - [子图布局](82.md)
    - [颜色](83.md)
    - [线条和点的样式](84.md)
    - [坐标轴](85.md)
    - [刻度](86.md)
    - [文本](87.md)
    - [图例](88.md)
    - [网格设置](89.md)
  - [Matplotlib扩展](90.md)
    - [使用BaseMap绘制地图](91.md)
    - [3D绘图工具包](92.md)
- [科学计算工具包SciPy](93.md)
  - [SciPy概览](94.md)
  - [安装配置](95.md)
  - [数据插值](96.md)
    - [一维插值](97.md)
    - [二维插值](98.md)
    - [离散数据插值到网格](99.md)
  - [曲线拟合](100.md)
    - [最小二乘法拟合](101.md)
    - [使用curve_fit()函数拟合](102.md)
    - [多项式拟合函数](103.md)
  - [傅里叶变换](104.md)
    - [时域到频域的转换](105.md)
    - [一维傅里叶变换的应用](106.md)
    - [二维傅里叶变换的应用](107.md)
  - [图像处理](108.md)
    - [图像卷积](109.md)
    - [边缘检测](110.md)
    - [侵蚀和膨胀](111.md)
    - [图像测量](112.md)
  - [积分](113.md)
    - [对给定函数的定积分](114.md)
    - [对给定样本的定积分](115.md)
    - [二重定积分](116.md)
  - [非线性方程求解](117.md)
    - [非线性方程](118.md)
    - [非线性方程组](119.md)
  - [线性代数](120.md)
    - [计算矩阵的行列式](121.md)
    - [求解逆矩阵](122.md)
    - [计算特征向量和特征值](123.md)
    - [矩阵的奇异值分解](124.md)
    - [求解线性方程组](125.md)
  - [聚类](126.md)
    - [k-means聚类](127.md)
    - [层次聚类](128.md)
  - [空间计算](129.md)
    - [空间旋转的表述](130.md)
    - [三维旋转](131.md)
- [机器学习工具包Scikit-learn](132.md)
  - [Scikit-learn概览](133.md)
  - [安装配置](134.md)
  - [数据集](135.md)
    - [Scikit-learn自带的数据集](136.md)
    - [样本生成器](137.md)
    - [加载其他数据集](138.md)
  - [数据预处理Preprocessing](139.md)
    - [标准化](140.md)
    - [归一化](141.md)
    - [正则化](142.md)
    - [离散化](143.md)
    - [特征编码](144.md)
    - [缺失值补全](145.md)
  - [分类Classification](146.md)
    - [K-近邻分类](147.md)
    - [贝叶斯分类](148.md)
    - [决策树分类](149.md)
    - [支持向量机分类](150.md)
    - [随机森林分类](151.md)
    - [集成学习Bagging/Boosting](152.md)
    - [神经网络模型](153.md)
  - [回归Regression](154.md)
    - [线性回归](155.md)
    - [Lasso回归](156.md)
    - [支持向量机回归](157.md)
    - [K-近邻回归](158.md)
    - [决策树回归](159.md)
    - [随机森林回归](160.md)
    - [逻辑回归](161.md)
  - [聚类Clustering](162.md)
    - [K-Means聚类](163.md)
    - [均值漂移聚类](164.md)
    - [基于密度的空间聚类](165.md)
    - [谱聚类](166.md)
    - [层次聚类](167.md)
  - [成分分解与降维](168.md)
    - [主成分分析](169.md)
    - [因子分析](170.md)
    - [截断奇异值分解](171.md)
    - [独立成分分析ICA（Independent Component Analysis）](172.md)
  - [模型评估与参数调优](173.md)
    - [估计器得分](174.md)
    - [交叉验证](175.md)
    - [评价指标](176.md)
    - [参数调优](177.md)
    - [模型持久化](178.md)
- [深度学习](179.md)
  - [神经网络基础知识](180.md)
    - [人工智能发展历史](181.md)
    - [神经元](182.md)
    - [BP神经网络](183.md)
    - [梯度下降](184.md)
    - [激励函数](185.md)
    - [过拟合、欠拟合](186.md)
    - [优化器Optimizer](187.md)
    - [常用开发工具](188.md)
  - [环境配置](189.md)
    - [Windows搭建深度学习环境](190.md)
    - [Linux搭建深度学习环境](191.md)
    - [MacOS搭建深度学习环境](192.md)
    - [CPU/GPU环境搭建](193.md)
  - [Theano](194.md)
    - [Theano基础知识](195.md)
    - [定义Layer](196.md)
    - [CNN](197.md)
    - [RNN(GRU/LSTM)](198.md)
    - [Autoencoder](199.md)
    - [神经网络参数保存](200.md)
    - [神经网络性能评价](201.md)
  - [TensorFlow](202.md)
    - [TensorFlow基础知识](203.md)
    - [Tensor](204.md)
    - [Session](205.md)
    - [Variable](206.md)
    - [Placeholder](207.md)
    - [Dropout](208.md)
    - [Tensorboard](209.md)
    - [CNN](210.md)
    - [RNN(GRU/LSTM)](211.md)
    - [Autoencoder](212.md)
    - [GNN](213.md)
    - [神经网络参数保存](214.md)
    - [神经网络性能评价](215.md)
  - [Keras](216.md)
    - [Keras基础语法](217.md)
    - [兼容Backend](218.md)
    - [函数模型和序列模型](219.md)
    - [定义Layer](220.md)
    - [CNN](221.md)
    - [RNN(GRU/LSTM)](222.md)
    - [Autoencoder](223.md)
    - [GNN](224.md)
    - [迁移学习](225.md)
    - [BiLSTM-Attention](226.md)
    - [生成对抗网络GAN](227.md)
    - [神经网络参数保存](228.md)
    - [神经网络性能评价](229.md)
  - [PyTorch](230.md)
    - [PyTorch基础知识](231.md)
    - [Tensor](232.md)
    - [Variable](233.md)
    - [定义Layer](234.md)
    - [可视化](235.md)
    - [CNN(TextCNN)](236.md)
    - [RNN(GRU/LSTM)](237.md)
    - [Autoencoder](238.md)
    - [GNN/GCN](239.md)
    - [迁移学习](240.md)
    - [生成对抗网络GAN](241.md)
    - [神经网络参数保存](242.md)
    - [神经网络性能评价](243.md)
  - [强化学习](244.md)
    - [强化学习概念](245.md)
    - [Q-Learning](246.md)
    - [Sarsa](247.md)
    - [DQN(Deep Q Network)](248.md)
    - [Policy Gradients](249.md)
    - [Actor Critic](250.md)
- [计算机视觉](251.md)
  - [数字图像处理基础](252.md)
    - [数字图像处理](253.md)
    - [像素及图像处理分类](254.md)
    - [图像信号数字换处理](255.md)
  - [OpenCV基础](256.md)
    - [安装配置](257.md)
    - [OpenCV基础语法](258.md)
    - [OpenCV显示图像](259.md)
    - [几何图形绘制](260.md)
  - [图像处理入门](261.md)
    - [读取显示图像](262.md)
    - [读取修改像素](263.md)
    - [创建复制保存图像](264.md)
    - [获取图像属性及通道](265.md)
  - [图像算数与逻辑运算](266.md)
    - [图像加法运算](267.md)
    - [图像减法运算](268.md)
    - [图像与运算](269.md)
    - [图像或运算](270.md)
    - [图像异或运算](271.md)
    - [图像非运算](272.md)
  - [图像几何变换](273.md)
    - [平移变换](274.md)
    - [缩放变换](275.md)
    - [旋转变换](276.md)
    - [镜像变换](277.md)
    - [仿射变换](278.md)
    - [透视变换](279.md)
  - [图像量化与采样](280.md)
    - [图像量化处理](281.md)
    - [图像采样处理](282.md)
    - [图像金字塔](283.md)
    - [局部马赛克处理](284.md)
  - [直方图统计](285.md)
    - [直方图概述](286.md)
    - [直方图绘制](287.md)
    - [掩膜直方图](288.md)
    - [H-S直方图](289.md)
    - [直方图对比](290.md)
  - [图像增强](291.md)
    - [图像增强](292.md)
    - [直方图均衡化](293.md)
    - [局部直方图均衡化](294.md)
    - [自动色彩均衡化](295.md)
    - [图像去雾](296.md)
  - [图像平滑](297.md)
    - [图像平滑概述](298.md)
    - [均值滤波](299.md)
    - [方框滤波](300.md)
    - [高斯滤波](301.md)
    - [中值滤波](302.md)
    - [双边滤波](303.md)
  - [图像锐化及边缘检测](304.md)
    - [一阶微分算法、二阶微分算子](305.md)
    - [Roberts算子](306.md)
    - [Prewitt算子](307.md)
    - [Sobel算子](308.md)
    - [Laplacian算子](309.md)
    - [Scharr算子](310.md)
    - [Canny算子](311.md)
    - [LOG算子](312.md)
  - [图像形态学处理](313.md)
    - [图像腐蚀](314.md)
    - [图像膨胀](315.md)
    - [图像开运算](316.md)
    - [图像闭运算](317.md)
    - [图像梯度运算](318.md)
    - [图像顶帽运算](319.md)
    - [图像底帽运算](320.md)
  - [图像分割](321.md)
    - [基于阈值的图像分割](322.md)
    - [基于边缘检测的图像分割](323.md)
    - [基于纹理背景的图像分割](324.md)
    - [基于K-Means聚类的区域分割](325.md)
    - [基于均值漂移算法的图像分割](326.md)
    - [基于分水岭算法的图像分割](327.md)
    - [图像漫水填充分割](328.md)
    - [文字区域分割及定位](329.md)
  - [傅里叶变换](330.md)
    - [傅里叶变换](331.md)
    - [傅里叶逆变换](332.md)
    - [高通滤波器](333.md)
    - [低通滤波器](334.md)
  - [霍夫变换](335.md)
    - [霍夫变换](336.md)
    - [霍夫线变换](337.md)
    - [霍夫圆变换](338.md)
  - [图像特效处理](339.md)
    - [图像毛玻璃特效](340.md)
    - [图像浮雕特效](341.md)
    - [图像素描特效](342.md)
    - [图像怀旧特效](343.md)
    - [图像流年特效](344.md)
    - [图像滤镜特效](345.md)
    - [图像水波特效](346.md)
    - [图像卡通特效](347.md)
  - [图像分类](348.md)
    - [图像分类概述](349.md)
    - [基于机器学习的图像分类](350.md)
    - [基于深度学习的图像分类](351.md)
    - [LeNet](352.md)
    - [VGG](353.md)
    - [AlexNet](354.md)
    - [ResNet](355.md)
  - [人脸识别](356.md)
  - [目标检测](357.md)
    - [目标检测概述](358.md)
    - [RCNN](359.md)
    - [Fast-RCNN](360.md)
    - [SPPNet](361.md)
    - [Mask-RCNN](362.md)
    - [SSD](363.md)
    - [YOLO系列算法](364.md)
- [自然语言处理](365.md)
  - [自然语言处理概览](366.md)
    - [自然语言处理的基本概念](367.md)
    - [自然语言处理的面临困难](368.md)
    - [自然语言处理的研究现状](369.md)
  - [预备知识](370.md)
    - [概率论基础知识](371.md)
    - [最大似然估计](372.md)
    - [隐马尔可夫模型](373.md)
    - [贝叶斯网络](374.md)
    - [条件概率分布](375.md)
    - [信息论基础知识](376.md)
    - [熵](377.md)
    - [困惑度](378.md)
    - [互信息](379.md)
    - [神经网络基础知识](380.md)
    - [CRF](381.md)
    - [BiLSTM+Attention](382.md)
    - [迁移学习](383.md)
    - [常用语料库和知识库](384.md)
  - [jieba](385.md)
    - [jieba概述](386.md)
    - [jieba分词](387.md)
    - [jieba添加自定义词典](388.md)
    - [jieba词性标注](389.md)
    - [jieba关键词抽取](390.md)
  - [nltk](391.md)
    - [nltk概述](392.md)
    - [nltk字符串处理](393.md)
    - [nltk词性标注](394.md)
    - [nltk词干提取](395.md)
    - [nltk命名实体识别](396.md)
    - [nltk分块处理](397.md)
    - [nltk文本分类](398.md)
    - [nltk情感分析](399.md)
  - [Genism](400.md)
    - [TF-IDF](401.md)
    - [similarities](402.md)
    - [LSA](403.md)
    - [LDA](404.md)
    - [Word2vec](405.md)
  - [词法分析](406.md)
    - [分词(英文分词/中文分词)](407.md)
    - [词干提取](408.md)
    - [词形还原](409.md)
    - [词性标注](410.md)
  - [句法分析](411.md)
    - [短语结构分析](412.md)
    - [依存句法分析](413.md)
  - [语义分析](414.md)
    - [命名实体消歧](415.md)
    - [指代消解](416.md)
    - [语义角色标注](417.md)
    - [语义关系抽取](418.md)
    - [语义依存分析](419.md)
    - [抽象语义表示](420.md)
  - [词嵌入](421.md)
    - [Word2Vec](422.md)
    - [GloVe](423.md)
    - [fastText](424.md)
    - [ELMo](425.md)
    - [BERT](426.md)
    - [XLNet](427.md)
  - [文本挖掘](428.md)
    - [文本相似度计算](429.md)
    - [文本聚类](430.md)
    - [文本分类](431.md)
    - [文本摘要](432.md)
  - [情感分析](433.md)
    - [基于情感词典的情感分析](434.md)
    - [基于深度学习的情感分析](435.md)
  - [主题模型](436.md)
    - [LSA](437.md)
    - [LDA](438.md)
  - [机器翻译](439.md)
    - [IBM统计翻译模型](440.md)
    - [短语抽取](441.md)
    - [语言模型](442.md)
    - [GNMT](443.md)
    - [Seq2Seq](444.md)
    - [Transformer](445.md)
  - [语言模型](446.md)
    - [n-gram](447.md)
    - [Pitman-Yor过程模型](448.md)
    - [AWD-LSTM](449.md)
    - [Transformer-XL](450.md)
    - [Gated CNN](451.md)
  - [智能问答](452.md)
    - [基于知识的问答](453.md)
    - [基于检索的问答](454.md)
    - [阅读理解](455.md)
    - [完形填空](456.md)
  - [智能对话](457.md)
    - [对话行为分类](458.md)
    - [对话状态跟踪](459.md)
    - [检索式聊天机器人](460.md)
    - [生成式聊天机器人](461.md)
    - [意图识别](462.md)
    - [槽填充(Slot Filling)](463.md)
  - [语音识别](464.md)
    - [傅里叶变换](465.md)
    - [声学模型](466.md)
    - [隐马尔可夫模型](467.md)
    - [CNN](468.md)
    - [LSTM-HMM](469.md)
    - [神经网络语言模型](470.md)
    - [MFCC](471.md)
  - [知识图谱](472.md)
    - [知识图谱构建](473.md)
    - [知识计算](474.md)
    - [知识存储](475.md)
    - [知识服务与应用](476.md)

# 附件
- [相关学习资源](appendixA.md)
- [实操案例](appendixB.md)