# Python 初阶

> 这里放制作好的图

## Python 成长路线图（初阶）

- 预备知识
  - Python简介
  - 程序设计思想
  - 安装Python
    - Windows安装Python
    - Linux安装Python
    - MacOS安装Python
  - 运行方式
    - 以交互方式运行
    - 以脚本方式运行
  - 常用开发工具
  - 编码规范
  - 模块管理
    - pip
- 基础语法
  - 缩进规则
    - 建议使用4个空格
  - 基础知识
    - 注释
    - 变量
    - 语句
    - 标识符
    - 命名规则
    - 运算与表达式
    - 代码风格
  - 函数
    - 函数定义def
    - 参数var
    - 返回值return
    - 参数传递
    - 函数调用
    - 函数递归
    - 函数编写风格
  - 类
    - 类定义class
    - 作用域和命名空间
    - 对象
    - 实例
    - 属性和方法
    - 类编码风格
  - 顺序语句结构
  - 分支语句结构
    - if
    - elif
    - else
    - 条件判断
  - 循环语句结构
    - for
    - while
    - break
    - continue
    - 循环判断
  - 数据类型
    - 整型
    - 浮点型
    - 布尔型
    - 字符串
  - 内置类
    - 列表list
    - 字典dict
    - 元组tuple
    - 集合set
    - 整型int
    - 字符串str
  - 常用内置函数
    - help
    - input
    - print
    - type
    - format
    - enumerate
    - len
    - sorted
    - isinstance
    - range
    - open
    - dir
    - zip
- 进阶语法
  - 列表推导式
  - 三元表达式
  - 断言
  - with-as
  - 异常捕获预处理
    - try-catch-finally
    - 异常捕获
  - 字符串方法
    - find
    - index
    - join
    - lower
    - replace
    - split
    - strip
    - translate
    - upper
  - lambda函数
    - 迭代器
    - 生成器
    - 装饰器
    - 闭包
  - 文件
    - 打开文件
    - 文件基本方法
    - 文件内容迭代
  - 常用标准库
    - datetime
    - json
    - math
    - os
    - random
    - re
    - sys
    - time
    - urllib
  - 字符编码与解码
    - 理解内码和字节码的概念
- 面向对象编程
  - 类和对象的概念
  - 类成员
  - 静态变量和实例变量
  - 面向对象三要素
    - 封装
    - 继承
    - 多态
  - 创建类
  - 实例化
  - 抽象类
  - 单实例模式


## 相关学习资源

1. [Python官网](https://www.python.org/)
2. 《Python基础教程（第2版）》 著：Magnus Lie Hetland  译：司维、曾军崴、谭颖华，人民邮电出版社
3. [中国大学MOOC《Python语言程序设计》北京理工大学：嵩天老师](https://www.icourse163.org/course/BIT-268001)
4. [Python 3.x documentation](https://docs.python.org/3/)
5. [Python基础教程](https://www.runoob.com/python/python-basic-syntax.html)