---
title: "DevOps 技术路线图"
date: 2018-12-29
lastmod: 2020-01-05
weight: 3
type: docs
icon: #
description: "完整路线图"
# search related keywords
---

## 路线图

{{< embed-pdf-view url="/images/DevOps.pdf" >}}


### [精益及DevOps概念](overview/)

- 精益
  - 精益屋
    - 采用类似房屋结构的方式形象化精益思想
  - 精益5原则
    - 价值
    - 价值流
    - 流动
    - 拉动
    - 尽善尽美
- DevOps
  - DevOps价值观
    - 利益相关方的反馈至关重要
    - 超越当今流程的极限进行改进
    - 不要用新的孤岛来打破旧的孤岛
    - 了解你的客户意味着跨组织协作
    - 通过热情鼓励采纳
  - DevOps原则
    - 基础设施即代码（Infrastructure as Code）
    - 持续交付（Continuous Delivery）
    - 协同工作（Culture of Collaboration）
### [敏捷研发](alige/)

- 敏捷概念
  - 敏捷宣言
    - 个体和互动高于流程和工具
    - 工作的软件高于详尽的文档
    - 客户合作高于合同谈判
    - 响应变化高于遵循计划 
  - 敏捷原则
    - 我们最重要的目标，是通过及早和持续不断地交付有价值的软件使客户满意
    - 欣然面对需求变化，即使在开发后期也一样，为了客户的竞争优势，敏捷过程掌控变化
    - 经常地交付可工作的软件，相隔几星期或一两个月，倾向于采取较短的周期
    - 业务人员和开发人员必须相互合作，项目中的每一天都不例外
    - 激发个体的斗志，以他们为核心搭建项目，提供所需的环境和支援，辅以信任，从而达成目标
    - 不论团队内外，传递信息效果最好效率也最高的方式是面对面的交谈
    - 可工作的软件是进度的首要度量标准
    - 敏捷过程倡导可持续开发，责任人、开发人员和用户要能够共同维持其步调稳定延续
    - 坚持不懈地追求技术卓越和良好设计，敏捷能力由此增强
    - 以简洁为本，它是极力减少不必要工作量的艺术
    - 最好的架构、需求和设计出自自组织团队
    - 团队定期地反思如何能提高成效，并依此调整自身的行为表现
- 敏捷实践框架
  - 看板（kanban）
    - 最轻量的敏捷研发实践
  - Scrum
    - 当前最主流的敏捷研发实践
  - XP
    - 极限编程（Extreme Programming）
  - SAFe
    - 规模化敏捷框架SAFe（Scaled Agile Framework），是当前应用最广的大规模敏捷框架
  - LeSS
    - LeSS（Large Scale Scrum），是最容易由Scrum升级的规模化敏捷实施框架
  - DaD
    - 规范敏捷交易DaD（Disciplined Agile Delivery）
- 敏捷研发管理工具
  - Jira
  - TFS
  - TAPD 
  - 禅道

### [代码开发](code/)
- 最少掌握一门开发语言
  - 代码编码
  - 代码规范
  - 代码评审
    - Gerrit
    - Phabricator
    - ReviewBoard
  - 特性开关
  - 代码架构
    - 微服务
    - 前后端分离
    - 无服务
    - 低代码开发
  - 代码重构
  - 代码编译原理
- 代码配置管理（Git）
  - Git应用
    - Git命令
    - Git分支应用
    - Git工作流
  - Git访问方式
    - HTTP
    - HTTPS
    - SSH
    - File
  - Git工作区 
    - 工作区
    - 暂存区
    - 版本库
    - 远程仓库作用
  - Git算法
    - 最近公共祖先算法LCA
    - merge算法
    - rebase算法
  - 开发类库
    - Jgit
    - libgit2
- 代码化
  - Pipeline as Code
  - Infrastructure as Code
- 编码实践
  - 测试驱动开发TDD（Test-Driven Development）
  - 结对编程
- Cloud IDE
  - 成熟工具
    - VS Code
    - Cloud9
    - Eclipse Che
    - Theia
  - 语言服务器协定LSP（Language Server Protocol） 
  - LSIF(Language Server Index Format)
  - 调试适配器协议DAP（Debug Adapter Protocol） 

### [持续集成](ci/)

- 持续集成工具
  - Jenkins
  - GitLib CI
  - 蓝盾
  - CircleCI
  - Travis CI
  - Tekton
- 编译构建
  - Maven
  - Gradle
  - Bazel
  - Blade
- 代码静态检查
  - SonarQube
  - Converity
  - Cppcheck
  - PMD
  - FindBugs
  - Clang Static Analyzer


### [持续测试](test/)
- 测试方法论与实践
  - 测试四象限
  - 测试金字塔
  - 测试左移/右移
  - Good Enough Testing
  - 开发自测
  - 结对测试
  - 验收测试
  - 探索性测试
  - A/B测试
  - 质量红线
    - 每日构建
    - 版本转测
    - 发布上线
    - 安全规则指标集
- 自动化测试
  - 单元测试
    - JUnit
    - PyUnit
    - CppUnit
    - GoTEST
  - 接口测试
    - JMeter
    - Postman
  - UI自动化测试
    - Appium
    - Selenium


### [持续发布部署](cd/)

- 软件包管理
  - Nexus
  - Artifactory
- 自动化部署
  - Ansible
  - SaltStack
  - Terraform
- 灰度发布
  - Nginx/Istio等


### [环境运维](env/)
- PaaS
  - 中间件
    - 应用中间件
    - 数据中间件
  - 主流供应商
    - AWS/Azure/阿里云/腾讯云/华为云/滴滴云
- 容器化
  - Docker
    - docker命令/dockerfile
    - cgroup
    - namespace
  - Kubernetes
    - kubectl
    - CRD(Custom Resource Definition)
    - CNI(Container Network Interface)
    - CSI(Container Storage Interface)
    - CRI(Container Runtime Interface)
  - 流量管控
    - iptables/Netfilter
    - IPvlan
- 操作系统
  - 主流操作系统
    - Linux/Windows/Android/iOS
  - 操作系统命令 
  - 操作系统原理 
- 文件系统
  - 分层文件系统
    - AUFS(Advanced Multi-layered Unification Filesystem)
    - overlayFS
    - overlay2
  - 文件系统扩展
    - FUSE(Filesystem in Userspace)
    - VFS(Virtual Filesystem)
  - 分布式文件系统
    - CephFS(Ceph Filesystem)
    - NAS(Network-attached Storage)


### [持续监控与反馈](monitor/)

- 日志监控
  - ELK(Elasticsearch、Logstash、Kibana) 
- 基础设施、数据库、中间件、应用监控
  - Zabbix
  - Prometheus
  - Falcon
- 应用性能监控
  - Zipkin
  - SkyWalking
  - Pinpoint
  - Sentry
- 用户反馈与分析
  - 问题反馈收集分析
    - 问题反馈，常用的收集为客服和工单系统，也有全开放式的客户吐槽应用
  - 用户行为数据分析
    - Google Analytics
  - 用户运营数据分析
  - 用户舆情分析
