---
title: "音视频技术中阶"
date: 2018-12-29
lastmod: 2020-01-05
weight: 2
type: docs
icon: #
description: "中阶路线图"
# search related keywords
---

## 中阶路线图

{{< embed-pdf-view url="/images/Audio.pdf" >}}


### 计算机类基本理论

- 通信类基本理论
  - 信号与系统理论
  - 统计信号处理
- 深度学习
  - 统计学习方法
  - 机器学习
  - 深度学习

### 音频编码关键技术

- 波形编码
  - 脉冲编码调制PCM (Pulse Code Modulation)
  - 自适应差分脉冲编码调制ADPCM (Adaptive Differential PCM)
  - 子带-自适应差分脉冲编码调制SB-ADPCM (Subband ADPCM)
- 参数编码
  - 线性预测编码LPC (Linear Predictive Coding)
- 混合编码
  - 码激励线性预测编码CELPC (Code-excited Linear Predictive Coding)
  - 矢量和激励线性预测编码VSELPC (Vector Sum Excited Linear Predictive Coding)
  - 规则脉冲激励长时预测RPE-LTP (Regular Pulse Excited-Long Term Prediction)
  - 低时延码激励线性预测LD-CELP (Low Delay-Code Excited Linear Prediction)
  - 多脉冲激励MPE (Multi-Pulse Excitation）
- 共轭结构代数码本激励线性预测编码方案CS-ACELP (conjugate-structure algebraic CELP)
  - 自适应预测编码技术
  - 矢量量化
  - 合成分析
  - 感觉加权


### 视频编码框架和关键技术
  
- 基于预测加变换的混合视频编码框架 (Hybrid Video Coding)
  - 预测技术
    - 空域预测
    - 时域预测
  - 变换技术
    - 离散余弦变换
    - 离散正弦变换
    - 小波变换
    - KLT (Karhunen-Loève Transform)
  - 量化技术
    - 标量量化
    - 矢量量化
    - Trellis quantization
    - RDOQ（Rate-Distortion Optimized Quantization）
  - 熵编码
    - 霍夫曼编码
    - 算术编码
    - 游程编码
  - 滤波技术
    - Deblocking filter
    - Wiener-based adaptive filter
  - 模式决策技术
  - 码率控制技术
  - GoP Structure
- 可伸缩视频编码技术
  - 时域可伸缩
  - 空域可伸缩
  - 质量可伸缩
- 多视点视频编码
  - 视差估计
  - 虚拟视图合成

### 音视频处理

- 音频回声
- 音频降噪
- 视频预处理
  - 降噪
  - 暗光处理
  - 感兴趣区域检测与编码
- 视频后处理
  - 质量增强
    - 去振铃 (Deringing)
    - 亮度调整 (Luminance Alterations)
    - 去闪烁 (Deflicking)
    - 锐化 (Sharpen)/去锐化 (Unsharpen)
  - 帧率提升
  - 图像/视频分辨率缩放
    - 视频超分 (Super Resolution)
    - 线性插值 (Linear Interpolation)
    - 双线性插值 (Bilinear Interpolation)
    - 三次/双三次 (Cubic/Bicubic Interpolation)
    - 最近邻插值 (Nearest-Neighbouring Interpolation)
    - Lanczos 重采样 (Lanczos Resampling)
  - 去交错 (Deinterlacing)
    - 场域内反交错 (Intra-Field Deinterlacing)
    - 场域间反交错 (Inter-Field Deinterlacing）
    - 动态适应性反交错 (Motion Adaptive Deinterlacing）
    - 动态补偿反交错 (Motion Compensated Deinterlacing)
  - 视频稳像 (Video Stabilization)

### 音视频传输

- 传输协议
  - TCP
  - UDP
  - 实时传输协议RTP（Real-time Transport Protocol）
  - HLS (HTTP Live Streaming)
  - DASH (Dynamic Adaptive Streaming over HTTP)

## 相关学习资源

1. 高文. 赵德斌. 马思伟著，科学出版社，《视频编解码技术原理》，2010.11
2. 周志华著，《机器学习》 ，2016年1月
3. 李航著，《统计学习方法》，2012年3月
4. [斯坦福大学Bernd Girod教授课程](http://web.stanford.edu/class/ee398a/)
5. 陶布曼，魏江力，柏正尧 等 著，《 JPEG2000图像压缩基础. 标准和实践》
6. Alan V. Oppenheim and Ronald W. Schafer, “Digital Signal Processing”, 1975
7. [Alan V. Oppenheim, Alan S. Willsky, with S. Hamid-Signals and Systems-Prentice Hall (1996)](https://eee.guc.edu.eg/Courses/Communications/COMM401%20Signal%20&%20System%20Theory/Alan%20V.%20Oppenheim,%20Alan%20S.%20Willsky,%20with%20S.%20Hamid-Signals%20and%20Systems-Prentice%20Hall%20(1996).pdf)
8. Alan V. Oppenheim and Ronald W. Schafer, “Discrete-Time Signal Processing”, 1989
9. Rafael C. Gonzales, “Digital Image Processing”, 1977
10. Dimitris Manolakis, Stephen M. Kogon, and Vinay K. Ingle, “Statistical and adaptive signal processing”, 2000.
11. Yao Wang, Jörn Ostermann, and Ya-Qin Zhang, “Video Processing and Communications”
12. Nuggehally S. Jayant, Peter Noll, “Digital coding of waveforms: principles and applications to speech and video”, 1990
13. Andreas Spanias, Atti Venkatraman, and Ted Painter, “Audio Signal Processing and Coding”, Dec. 2005
14. Ted Painter, and Andreas Spanias, “Perceptual Coding of Digital Audio”, Proc. IEEE, vol. 88, no. 4, pp. 451-515, 2000.