---
title: "音视频技术高阶"
date: 2018-12-29
lastmod: 2020-01-05
weight: 3
type: docs
icon: #
description: "高阶路线图"
# search related keywords
---

## 高阶路线图

{{< embed-pdf-view url="/images/Audio.pdf" >}}

### 视频编解码理论

- 率失真理论基础
- 运动补偿理论基础
- 变换量化理论基础
- 算术编码理论基础

### 视频编码新方案

- 端到端图像/视频编码框架（End-to-End Image/Video Coding）
- 与传统编码框架相结合的编码框架
- LCEVC标准 (Low Complexity Enhancement Video Coding)

### 视频编码新应用

- 点云压缩
- 全景视频压缩
- 六度自由度6DoF (Six Degrees of Freedom)

### 音频丢包补偿技术

- 基于发送端的丢包补偿方案
  - 主动重传
  - 被动通道编码
    - 前向差错纠正技术FEC (Forward Error Correction)
    - 基于交织的技术
      - 与媒体无关的方法
      - 利用音频属性的媒体相关方法
- 基于接收端的丢包补偿方案
  - 基于插入的方法
    - 拼接法 (Splicing)	
    - 静音置换法 (Silence substitution)
    - 噪声置换法 (Noise substitution)
    - 重复法 (Repetition)
  - 基于插值的方法
    - 波形置换法 (Waveform substitution)
    - 基音波形复制法 (Pitch waveform replication)
    - 时间尺度修正法 (Time scale modification)
  - 基于重构的方法
    - 传输状态插值法 (Interpolation of transmitted state)
    - 基于模型的恢复法 (Model-based recovery)

### 视频差错控制技术

- 信道编码差错控制技术
  - 有条件的自动请求ARQ (Automatic repeat request)
  - 基于反馈信息的参考帧选择RPS（Reference Picture Selection）
  - 误码跟踪
- 编码器差错恢复
  - 分层编码
  - 多描述编码
  - 前向纠错编码
  - Intra更新
  - 独立分段编码
  - 差错弹性的熵编码EREC (Error-Resilient Entropy Code)
  - 可逆变长编码RLVC（Reversible Variable Length Code）
- 解码器差错隐藏
  - 编码模式恢复
  - 运动信息恢复
  - 纹理信息恢复


### 视频标准文本及参考软件

- 标准文本
  - H.265/HEVC标准文本
  - H.266/VVC标准文本	
- 参考软件
  - H.265/HEVC的参考软件：HM；开源软件 x265
  - AVS3参考软件：uAVS3e
  - VTM参考软件


## 相关学习资源

1. [Gary J. Sullivan and Thomas Wiegand, “Rate-Distortion Optimization for video compression”](https://web.stanford.edu/class/ee398a/handouts/papers/Sullivan%20-%20RD%20Opt%20for%20Video.pdf)
2. [Bernd Girod, Markus Flierl, “Video coding with superimposed motion compensated signals”, 2004](https://www.springer.com/gp/book/9781402077593?cm_mmc=sgw-_-ps-_-book-_-1-4020-7759-9)
3. R. J. Clarke, “Transform coding of images”, Jan. 1985
4. [P. G. Howard and J. S. Vitter, “Practical Implementations of Arithmetic Coding”](http://homepages.cae.wisc.edu/~ece533/resources/arithmeticcoding/howard.pdf)
5. [J. J. Rissanen, G. G., Jr Langdon (March 1979). “Arithmetic coding” (PDF). IBM Journal of Research and Development. 23 (2): 149–162](http://read.pudn.com/downloads75/sourcecode/zip/276150/image_compresion_by_sfj/reference/arithmetic/ibmrd2302G.pdf)
6. Aaron Courville, Ian Goodfellow, and Yoshua Bengio, “Deep Learning”, 2015
7. R. Schnabel and R. Klein, "Octree-based point-cloud compression", Symposium on Point-Based Graphics, July 2006.
8. ITU-T and ISO/IEC, “Advanced Video Coding for Generic Audiovisual Services,” ITU-T Rec. H.264 and ISO/IEC 14496-10, vers. 1, 2003.
9. ITU-T and ISO/IEC, “High Efficiency Video Coding,” ITU-T Rec. H.265 and ISO/IEC 23008-2, vers. 1, 2013.
10. B. Bross, J. Chen, S. Liu, and Y.-K. Wang, “Versatile Video Coding (Draft 10),” Document JVET-S2001 of JVET, Jun. 2020.
11. HM 参考软件: https://vcgit.hhi.fraunhofer.de/jct-vc/HM/tags/HM-16.20 
12. VTM参考软件: https://vcgit.hhi.fraunhofer.de/jvet/VVCSoftware VTM/tags/VTM-11.0
13. [T. Stockhammer, "Dynamic adaptive streaming over HTTP -- standards and design principles," MMSys'11: Proceedings of the second annual ACM conference on Multimedia systems, pp. 133–144, Feb. 2011. (视频链接)](https://doi.org/10.1145/1943552.1943572)
14. I. Sodagar, "The MPEG-DASH Standard for Multimedia Streaming Over the Internet," IEEE Multimedia, vol. 18, no. 4, Apr. 2011.
15. T. Schierl and S. Narasimhan, "Transport and Storage Systems for 3-D Video Using MPEG-2 Systems, RTP, and ISO File Format," Proceedings of the IEEE, vol. 99, no. 4, pp. 671-683, Apr. 2011.
16. G. K. Walker, T. Stockhammer, G. Mandyam, Y.-K. Wang, and C. Lo, "ROUTE/DASH IP Streaming-Based System for Delivery of Broadcast, Broadband, and Hybrid Services," IEEE Transactions on Broadcasting, vol. 62, no. 1, pp. 328-337, Mar. 2016.
17. Y. Wang, and Q.-F. Zhu, “Error control and concealment for video communication: A review,” Proceedings of the IEEE, vol. 86, no. 5, pp. 974-997, May 1998.
18. B. Girod and N. Farber, “Feedback-based error control for mobile video transmission,” Proc. of the IEEE, vol. 87, no. 10, pp. 1707-1723, Oct. 1999.
19. Y. Wang, S. Wenger, J. Wen, and A. K. Katsaggelos, “Error resilient video coding techniques,” IEEE Signal Process. Mag., vol. 17, no. 4, pp. 61–82, Jul. 2000.