---
title: "音视频技术初阶"
date: 2018-12-29
lastmod: 2020-01-05
weight: 1
type: docs
icon: #
description: "初阶路线图"
# search related keywords
---

## 初阶路线图

{{< embed-pdf-view url="/images/Audio.pdf" >}}


### 编程知识储备 

- 数据结构
  - 线性表 
  - 堆栈 
  - 串 
  - 树​ 
- 算法 
  - 递归 (Recursion) 
    - 最短路径 (Shortest Paths) 
    - 字符串匹配 (String-Searching/Matching Algorithm) 
      - KMP算法 (Knuth–Morris–Pratt Algorithm) 
      - BM字符串匹配算法 (Boyer–Moore String-Search Algorithm) 
      - 暴力匹配算法 (Brute Force Algorithm) 
    - 查找 
      - 二分查找 
      - 散列表查找 
      - 树结构查找 
    - 贪心算法 (Greedy Algorithms) 
      - 深度/广度- 优先搜索 (Depth/Breadth-First Search) 
- 编程语言 
  - C/C++ 
  - Pyhon 
  - 汇编语言 
  - MATLAB 
- 单指令流多数据流（SIMD） 
  - AVX指令、AVX2指令 
  - XOP、FMA4以及CVT16指令 
  - FMA指令 
  - F16C指令 
- 多线程技术 
  - 并发概念 
  - 死锁问题 
  - 线程状态 
    - 就绪 
    - 运行 
    - 睡眠 
- 硬件平台及相关的编程语言 
  - 硬件平台 
    - FPGA 
    - GPU 
    - ASIC 
  - 编程语言 
    - Verilog 
    - VHDL 
    - CUDA 

### 计算机类基本理论 

- 信息论基础 
  - 熵 
  - 数据压缩 
  - 率失真 
  - 信源编码 
  - 信道编码 
- 数字图像处理 
  - 去除噪声 
  - 增强 
  - 复原 
  - 分割 
  - 提取特征 

### 音视频编解码及转码 

- 编解码的基本概念 
  - 压缩的可行性 
    - 空域冗余 
    - 时域冗余 
    - 统计冗余 
    - 视觉冗余 
  - 压缩类型 
    - 无损压缩 
    - 有损压缩 
- 视频编码标准化工作组及标准 
  - 标准化工作组 
    - ISO/IEC MPEG 
    - ITU-T/VCEG 
    - AVS 
    - IEEE-SA (Standard Association) 
    - AOM 
  - 经典标准 
    - MPEG/VCEG系列标准 
      - H.261/H.262/H.263
      - H.264/AVC
      - H.265/HEVC
      - H.266/VVC
    - AVS系列标准 
      - AVS1-P2 (AVS1.0)
      - AVS1-P7 (AVS-M)
      - AVS2-P2
      - AVS3-P2
    - IEEE 1857.4 
    - AV1 
- 音频编码标准化工作组及标准 
  - 标准化工作组 
    - ISO/IEC MPEG 
    - ITU-T 
    - 3GPP 
    - AVS 
  - 经典标准 
    - MPEG系列标准 
      - MPEG-1 Layer III (MP3)
      - MPEG-2 AAC (Advanced Audio Coding)
    - ITU系列标准 
      - G.711
      - G.729
    - 3GPP系列标准 
      - AMR
      - AMVR-WB
      - AMR-WB+
    - AVS系列标准 
      - AVS1-P3
    - 企业标准 
      - Dolby AC-3
      - WMA (Windows Media Audio)
- 转码的基本概念 
  - 不同格式之间的转码技术 
  - 相同格式，不同分辨率/码率的转码技术


## 相关学习资源

1. 王爽，《汇编语言（第3版）》, [Assembly language]
2. 殷建平，徐云，王刚等译，《算法导论（原书第3版）》[Introduction to Algorithms, third edition]
3. 姜丹 《信息论与编码》
4. 冈萨雷斯 《数字图像处理》
5. 程佩青《数字信号处理教程》（第四版）
6. Iain Richardson，H.264和MPEG-4视频压缩
7. 《WebRTC权威指南》，2016
8. 刘歧/赵文杰，机械工业出版社，《FFmpeg从入门到精通》，2018
9. [Andreas Spanias, Ted Painter, Venkatraman Atti, “Audio Signal Processing and Coding”, December 2005](https://www.google.com/books/edition/Audio_Signal_Processing_and_Coding/a1RULRErhOYC?hl=en&gbpv=1&printsec=frontcover)
10. Wai C. Chu, “Speech Coding Algorithms: Foundation and Evolution of Standardized Coders”, April 2003.
11. Thomas H. Cormen, Charles E. Leiserson, Ronald L. Rivest, Clifford Stein, “Introduction to Algorithms”, 1989.
12. [Andrew D. Birrell , “An Introduction to Programming with Threads,” ](https://www.hpl.hp.com/techreports/Compaq-DEC/SRC-RR-35.pdf)
13. Mark Pesce, “DirectShow for Digital Video and Television”, 2003
14. T. Wiegand, Gary J. Sullivan, Gisle Bjøntegaard, Ajay Luthra, “Overview of the H.264/AVC video coding standard,” IEEE Transactions on Circuits and Systems for Video Technology, vol. 13, no. 7, pp.560–576, 7 2003, doi: 10.1109/TCSVT.2003.815165.
15. G. J. Sullivan, J. Ohm, W. Han and T. Wiegand, "Overview of the High Efficiency Video Coding (HEVC) Standard," in IEEE Transactions on Circuits and Systems for Video Technology, vol. 22, no. 12, pp. 1649-1668, Dec. 2012, doi: 10.1109/TCSVT.2012.2221191.