---
title: "传统表格化机器学习"
date: 2018-12-29
lastmod: 2020-01-05
weight: 3
type: 
icon: #
description: "人工智能初阶路线图,传统表格化机器学习"
# search related keywords
---

- 传统模型及对应工具
  - 线性回归
  - 逻辑回归
  - SVM
  - KNN
  - MLP
- 树和集成树模型
  - Random Forest和Extra Trees
  - XGBoost
  - LightGBM
  - CatBoost
- 常见特征构建方法
  - 基于业务理解的特征构建方式
  - 常见的encoder
  - 常见的机遇探索性分析和Bad-Case分析方法构建模型
- 常见特征选择方法
  - 基于单变量检验的选择方法
  - 基于模型的自带选择方式(如树模型、线性回归、逻辑回归、L1损失等)
- 常见Stacking方法


## 相关学习资源


### 传统模型及对应工具

1. 《Pattern Recognition and Machine Learning》一书
2. [吴恩达机器学习公开课](https://www.youtube.com/watch?v=jGwO_UgTS7I&list=PLoROMvodv4rMiGQp3WXShtMGgzqpfVfbU)
3. [吴恩达深度学习公开课](https://www.youtube.com/watch?v=PySo_6S4ZAg&list=PLoROMvodv4rOABXSygHTsbvUz4G_YQhOb)
4. [Sklearn官方文档](https://scikit-learn.org/stable/user_guide.html)
5. 如需要GPU加速，请见[CuML文档](https://docs.rapids.ai/api/cuml/stable/)


### Random Forest和Extra Trees

1. 见LightGBM booster为rf时候的[相关文档](https://lightgbm.readthedocs.io/en/latest/)；不建议使用Sklearn API


### XGBoost

见[XgBoost文档](https://xgboost.readthedocs.io/en/latest/)


### LightGBM

见[LightGBM文档](https://lightgbm.readthedocs.io/en/latest/)


### CatBoost

见[Catboost文档](https://catboost.ai/)


### 常见特征构建方法

这部分并没有很好的书籍或文章介绍，更好的方法是根据Kaggle及其他主流比赛的Kernel进行总结


### 基于单变量检验的选择方法

目前比较好的文档是Sklearn当中feature selection模块的[文档](https://scikit-learn.org/stable/modules/feature_selection.html)


### 基于模型的自带选择方式(如树模型、线性回归、逻辑回归、L1损失等)

1. 对于树模型(如XgBoost，LightGBM等)最好的就是看官方文档
2. 对于L1模型，如果只对于常见模型感兴趣，可以看sklearn相关文档；如果想要深度了解，可以看[proximal methods](https://web.stanford.edu/~boyd/papers/pdf/prox_algs.pdf)的原理


### 常见Stacking方法

1. 介绍可以看<https://towardsdatascience.com/a-guide-to-ensemble-learning-d3686c9bed9a>
2. 更多的介绍只能看Kaggle比赛的一些经验