---
title: "人工智能高阶"
date: 2018-12-29
lastmod: 2020-01-05
weight: 3
type: docs
icon: #
description: "高阶路线图"
# search related keywords
keywords: ["人工智能","高阶"]
---


![高校俱乐部](https://codechina.csdn.net/codechina/operation-work/uploads/53b24f5f44d3c851890b1789ed501001/%E9%AB%98%E6%A0%A1%E4%BF%B1%E4%B9%90%E9%83%A8320.jpg)

<p style="text-align:center;font-weight:bold;">关注“高校俱乐部”微信公众号，快人一步获取高清全套技术路线图</p>

<br>


{{< embed-pdf-view url="/images/AI.pdf" >}}

### 数学基础

- 几何
  - 拓扑向量空间
  - Banach Lattice
  - Vector Measures
  - 再生核希尔伯特空间RKHS（Reproducing Kernel Hilbert Space）
  - 微分和黎曼几何
  - 动态系统
  - 最优化传输理论
- 代数
  - 基础代数
  - 算子代数
  - 谱理论
  - K理论
- 概率论和统计学
  - 随机分析及随机过程的收敛
  - 马尔可夫链和稳定性
  - 流行上的随机分析
  - 巴拿赫空间上的概率论
  - 高维统计基础
  - 经验过程
  - 贝叶斯理论基础
- 不等式
  - 基础数学不等式
  - 概率不等式
  - 高级不等式证明技巧


### 编程基础

- C++编程
  - Template Meta Programming
  - CPU调优
  - GPU调优
  - FPGA调优
- 深度学习框架深入
  - TensorFlow XLA代码细节研究
  - PyTorch XLA代码细节研究
  - Jax/Flax代码细节研究及模型复现

### AI通用进展

- 优化器及优化过程
- 神经网络架构搜索
  - 可微分方法
  - 基于增强学习的方法
- encoder refinement 方法
  - 基于Contrast Loss的预训练
  - 基于Self Training的优化
- 表征学习的优化
  - Triplet Loss and Online Triplet Mining
  - 其他优化方法
- Consistency Regularization
  - Unsupervised Data Augmentation
  - Adversarial Training Related Methods
- Mixture of Experts
- 基础网络设计方式
  - 普遍的layer设计trick，如Cascading、Pyramid Networks等
  - 神经网络中的Sparse问题

### CV前沿

- Multi-object Tracking
- 基于视频、多模态和知识图谱的召回体系

### NLP前沿

- 文本生成：如何结合模板和生成模型
- 知识图谱推理
- Semantic Parsing和Syntax Parsing及其应用
- 使用RL对机器人状态进行控制


### 图模型和推荐系统前沿

- 传统问题向GNN的转换
- 不同图嵌入和预训练方法
- 图模型和推荐系统的关系

### RL前沿

- Model-based RL
- Bayesian RL
- 提升模型样本利用率的方法
- Distributed RL
- Relational RL

### Meta Learning

- Few-shot Learning
  - 基于优化的方法
  - 基于贝叶斯的方法
- Meta Reinforcement Learning

### 逻辑推理

- Differentiable Neural Logic Machines
- 数理逻辑的理解
  - 数理逻辑和Lambda calculus的关系
  - Epistemic Logic

