#!/bin/bash
# 参考：https://coder.com/docs/code-server/install
# 一键安装命令: . <(curl -sSf https://gitcode.net/cloudswave/code-server/-/raw/master/ubuntu-debian/install.sh)
CONFIG_FILE=~/.config/code-server/config.yaml

echo -n "输入code-server版本(默认4.90.3): "
read VERSION
echo -n "输入code-server端口(默认8080): "
read port
echo -n "输入code-server密码(默认123456): "
read password
VERSION=${VERSION:-4.90.3}
port=${port:-8080}
password=${password:-123456}

# 添加默认配置到config.yaml
if [[ ! -e $CONFIG_FILE ]]; then
    echo 配置文件${CONFIG_FILE}不存在，正在创建...
    mkdir -p "$(dirname "$CONFIG_FILE")"
fi

rm -rf $CONFIG_FILE
# 追加默认配置
echo bind-addr: 0.0.0.0:${port} >> $CONFIG_FILE
echo 'auth: password' >> $CONFIG_FILE
echo password: ${password} >> $CONFIG_FILE
echo 'cert: false' >> $CONFIG_FILE
cat $CONFIG_FILE

echo 准备安装code-server:${VERSION}

curl -fOL https://mirror.ghproxy.com/https://github.com/coder/code-server/releases/download/v$VERSION/code-server_${VERSION}_amd64.deb
dpkg -i code-server_${VERSION}_amd64.deb
apt update
apt install -y screen
screen -dmS code /usr/bin/code-server --config $CONFIG_FILE ~
echo "等待5s..."
sleep 5
screen -ls

echo "服务器配置信息："
cat $CONFIG_FILE
