#!/bin/bash

# 文件名和URL
extracted_dir="code-server-4.90.2-linux-amd64"
filename="code-server-4.90.2-linux-amd64.tar.gz"
url="https://mirror.ghproxy.com/https://github.com/coder/code-server/releases/download/v4.90.2/${filename}"

# 检查解压后的目录是否存在，如果不存在则下载并解压
if [ ! -d "${extracted_dir}" ]; then
    # 检查文件是否存在，如果不存在则下载
    if [ ! -f "${filename}" ]; then
        echo "Downloading ${filename}..."
        wget "$url"
    fi
    echo "Extracting ${filename}..."
    tar -zxvf "${filename}"
else
    echo "Directory already exists, skipping extraction."
fi


# 清理压缩文件和解压后的目录
#rm -rf "${filename}" 

# 运行 code-server
echo "Starting code-server with config file..."
./$extracted_dir/bin/code-server --config ./config.yaml
