const http = require('http');
const fs = require('fs');
const path = require('path');
const childProcess = require('child_process');


let sshxProcess;
const server = http.createServer((req, res) => {
  console.log(req.url);
  if(req.url == "/sshx"){
    res.writeHead(200, { 'Content-Type': 'text/event-stream', 'Cache-Control': 'no-cache', 'Connection': 'keep-alive' });
    const print = (data)=>{
      console.log(data.toString());
      res.write(data.toString().replace(/\u001b\[[0-9;]*m/g, '').replace(/[^\x00-\x7F]/g, ''));
    }
    if(!sshxProcess) {
        sshxProcess = exec("curl -sSf https://sshx.io/get | sh;sshx", print);
    } else {
      sshxProcess.data.forEach(print);
      res.end();
    }
    return;
  } else if(req.url == "/"){
    req.url = "/index.html"
  }

 // 获取请求的文件路径
 const filePath = path.join(__dirname, 'public', req.url);

 // 检查文件是否存在
 fs.access(filePath, fs.constants.F_OK, (err) => {
   if (err) {
     // 文件不存在，返回404错误
     res.statusCode = 404;
     res.end('File not found');
     return;
   }

   // 读取文件
   fs.readFile(filePath, (err, data) => {
     if (err) {
       // 读取文件出错，返回500错误
       res.statusCode = 500;
       res.end('Internal server error');
       return;
     }

     // 设置响应头，指定文件类型
     res.setHeader('Content-Type', getContentType(filePath));

     // 发送文件内容
     res.end(data);
   });
 });
});

// 启动服务器，监听3000端口
server.listen(3000, () => {
 console.log('Server is running on port 3000');
});

// 根据文件路径获取文件类型
function getContentType(filePath) {
 const extname = path.extname(filePath);
 switch (extname) {
   case '.html':
     return 'text/html';
   case '.css':
     return 'text/css';
   case '.js':
     return 'text/javascript';
   case '.json':
     return 'application/json';
   case '.png':
     return 'image/png';
   case '.jpg':
     return 'image/jpg';
   case '.gif':
     return 'image/gif';
   default:
     return 'application/octet-stream';
 }
}

function exec(command, callback) {
    const process = childProcess.spawn('sh', ['-c', command]);
    process.data = [];
    process.stdout.on('data', (data) => {
      process.data.push(data);
      callback(data);
    });

    process.stderr.on('data', (data) => {
      process.data.push(data);
      callback(data);
    });

    process.on('close', (code) => {
      process.data.push(`Process exited with code ${code}`);
      callback(`Process exited with code ${code}`);
    });
    return process;
}
