/*
 * @Description: 全局二次确认组件
 */

import { ElMessage, ElMessageBox, ElLoading } from 'element-plus'

function useConfirmPopup(title, confirmCallBack, cancelCallback) {
  let confirmDisabled = false

  ElMessageBox.confirm(title, '提示', {
    confirmButtonText: '确认',// 确定按钮的文本内容
    cancelButtonText: '取消',// 取消按钮的文本内容
    type: 'warning', // 消息类型，用于图标显示[success/info/warning/error]
    closeOnClickModal: false,// 是否可通过点击遮罩层关闭 MessageBox [true:默认(可以)/false(不可以)]
    showClose: false,// MessageBox 是否显示右上角关闭按钮[true:默认(显示)/false(不显示)]
    beforeClose: async (action, instance, done) => {
      if (action === 'confirm') {
        confirmDisabled = true
        // 确认按钮触发事件
        const loadingInstance = ElLoading.service({
          target: '.el-message-box',
          text: '确认中...'
        })

        try {
          const res = await confirmCallBack()
          console.log('res',res)
          done()
        } catch (err) {
          console.log('err', err)
        } finally {
          confirmDisabled = false
          loadingInstance.close()
        }

      } else if (action === 'cancel') {
        debugger
        // 取消按钮触发事件
        if(confirmDisabled){
          ElMessage({
            type: 'error',
            message: '请求发送中，请勿点击取消'
          })
        }else{
          cancelCallback && cancelCallback()
          done()
        }
      }
    }
  })
}

export default useConfirmPopup