#逆向最大匹配算法BMM
def BMM(user_dict,sentence):
    #逆向最大匹配算法BMM
    #示例：user_dict=['时间', '就', '是', '⽣命']，sentence='时间就是⽣命'
    print('\n<<<逆向最大匹配算法BMM>>>')

    print('***开始切分BMM***')
    segment_words=[]
    max_len=max([len(item) for item in user_dict])
    start=len(sentence)
    k=0
    while start != 0:
        print('---第', k+1, '轮开始---')
        k+=1
        #句子切分结束位置
        index = start-max_len
        #结束位置大于句子长度
        if index<0:
            index=0

        for i in range(max_len):
            print(sentence[index:start])
            if (sentence[index:start] in user_dict) or (len(sentence[index:start])==1):#词在user_dict内或只有一个字
                segment_words.insert(0,sentence[index:start])
                start = index
                break
            #失败
            index+=1
        print('当前已经切分：', segment_words)
        print('---第', k, '轮结束---\n')
    print('***切分完毕***')
    print('分词结果：', segment_words)
    return segment_words

#正向最大匹配算法FMM
def FMM(user_dict,sentence):
    #正向最大匹配算法FMM
    #示例：user_dict=['时间', '就', '是', '⽣命']，sentence='时间就是⽣命'
    print('\n<<<正向最大匹配算法FMM>>>')

    print('***开始切分***')
    segment_words=[]
    max_len=max([len(item) for item in user_dict])
    start=0
    k=0
    while start != len(sentence):
        print('---第', k, '轮开始---')
        k+=1
        #句子切分结束位置
        index = start+max_len
        #结束位置大于句子长度
        if index>len(sentence):
            index=len(sentence)

        for i in range(max_len):
            print(sentence[start:index])
            if (sentence[start:index] in user_dict) or (len(sentence[start:index])==1):#词在user_dict内或只有一个字
                segment_words.append(sentence[start:index])
                start = index

                break
            #失败
            index-=1
        print('当前已经切分：', segment_words)
        print('---第', k, '轮结束---\n')
    print('***切分完毕***')
    return segment_words

if __name__ == '__main__':
    user_dict=['时间', '就', '是', '⽣命']
    sentence='时间就是⽣命'
    BMM(user_dict, sentence)
    FMM(user_dict, sentence)