import axios from 'axios'


const getHtmlDoc = (htmlString) => {
    const parser = new DOMParser();
    const doc = parser.parseFromString(htmlString, 'text/html');
    return doc
}

function traverse(node) {
    const children = []
    const name = node.nodeName
    // 遍历当前节点的子节点
    for (let i = 0; i < node.childNodes.length; i++) {
        const child = node.childNodes[i];
        // 如果是元素节点，打印节点名称，并递归遍历子节点
        if (child.nodeType === 1) {
            const childItem = traverse(child)
            children.push(childItem);
        }
    }
    return {
        name,
        children
    }
}

const genTreeData = async (htmlHref) => {
    // 请求 html 内容
    const {data:htmlContent}=await axios.get(htmlHref)

    console.log('htmlContent',htmlContent)

    const htmlDoc = getHtmlDoc(htmlContent)

    const treeData=traverse(htmlDoc.body)
    console.log('treeData',treeData)
    return treeData
}

export const treeData =genTreeData