import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'

// https://vitejs.dev/config/
export default defineConfig({
  server: {
    host: true,
    proxy: {
      "^/common-api/": {
        target: "https://yongma16.xyz/common-api/",
        changeOrigin: true,
        ws: true,
        rewrite: (path) => path.replace(/^\/common-api/, ""),
      },
      "^/article/": {
        target: "https://developer.aliyun.com/article/",
        changeOrigin: true,
        ws: true,
        rewrite: (path) => path.replace(/^\/article/, ""),
      },
    },
  },
  plugins: [vue()]
})
