// Copyright (c) 2021 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/phi/kernels/complex_kernel.h"
#include "paddle/phi/kernels/impl/complex_kernel_impl.h"

#include "paddle/phi/backends/cpu/cpu_context.h"
#include "paddle/phi/core/kernel_registry.h"

// See Note [ Why still include the fluid headers? ]
#include "paddle/phi/common/complex.h"

PD_REGISTER_KERNEL(conj,
                   CPU,
                   ALL_LAYOUT,
                   phi::ConjKernel,
                   phi::dtype::complex<float>,
                   phi::dtype::complex<double>,
                   float,
                   double,
                   int,
                   int64_t) {}

PD_REGISTER_KERNEL(real,
                   CPU,
                   ALL_LAYOUT,
                   phi::RealKernel,
                   phi::dtype::complex<float>,
                   phi::dtype::complex<double>) {
  kernel->OutputAt(0).SetDataType(phi::dtype::ToReal(kernel_key.dtype()));
}

PD_REGISTER_KERNEL(imag,
                   CPU,
                   ALL_LAYOUT,
                   phi::ImagKernel,
                   phi::dtype::complex<float>,
                   phi::dtype::complex<double>) {
  kernel->OutputAt(0).SetDataType(phi::dtype::ToReal(kernel_key.dtype()));
}
