// Copyright (c) 2021 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
#pragma once

#if !defined(_WIN32)
#include <sched.h>
#else
#define NOMINMAX
#include <windows.h>
#endif  // !_WIN32

#include <queue>
#include <vector>

#include "paddle/fluid/framework/new_executor/workqueue.h"
#include "paddle/fluid/memory/allocation/spin_lock.h"
#include "paddle/fluid/platform/device_event.h"

namespace paddle {
namespace framework {

using GarbageQueue = std::deque<std::shared_ptr<memory::Allocation>>;
class InterpreterCoreGarbageCollector {
 public:
  InterpreterCoreGarbageCollector();

  void Add(std::shared_ptr<memory::Allocation> garbage,  // NOLINT
           paddle::platform::DeviceEvent& event,         // NOLINT
           const platform::DeviceContext* ctx);

  void Add(paddle::framework::Variable* var,
           paddle::platform::DeviceEvent& event,  // NOLINT
           const platform::DeviceContext* ctx);

  DISABLE_COPY_AND_ASSIGN(InterpreterCoreGarbageCollector);

 private:
  void Free(GarbageQueue* garbages,
            paddle::platform::DeviceEvent& event,  // NOLINT
            const platform::DeviceContext* ctx);

  void Free(std::shared_ptr<memory::Allocation>& garbage,  // NOLINT
            paddle::platform::DeviceEvent& event,          // NOLINT
            const platform::DeviceContext* ctx);

  std::unique_ptr<GarbageQueue> garbages_;
  size_t max_memory_size_;
  size_t cur_memory_size_;
  std::unique_ptr<WorkQueue> queue_;
  paddle::memory::SpinLock spinlock_;
};
}  // namespace framework
}  // namespace paddle
