// Copyright (c) 2021 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once
#include "paddle/fluid/framework/new_executor/new_executor_defs.h"

namespace paddle {
namespace framework {

class EventManager {
 public:
  void RecordEvent(const Instruction& instruction,
                   const OpFuncNode& op_func_node,
                   const platform::Place& place);

  void WaitEvent(const Instruction& instruction, const platform::Place& place);

 private:
  void WaitOrSync(const std::vector<EventInter>& events,
                  const platform::DeviceContext* dev_ctx);
};

}  // namespace framework
}  // namespace paddle
