export const tableColumns= [
  {
    title: '文章名称',
    dataIndex: 'title',
    fixed: true
  }, {
    title: '链接',
    key: 'url'
  }, {
    title: '浏览量',
    dataIndex: 'viewCount',
    sorter: (a, b) => a.viewCount - b.viewCount,
  }, {
    title: '评论量',
    dataIndex: 'commentCount',
    sorter: (a, b) => a.commentCount - b.commentCount,
  }, {
    title: '收藏量',
    dataIndex: 'collectCount',
    sorter: (a, b) => a.collectCount - b.collectCount,
  },, {
    title: '点赞量',
    dataIndex: 'diggCount',
    sorter: (a, b) => a.diggCount - b.diggCount,
  },{
    title: '质量分',
    key: 'score',
    sorter: (a, b) => a.score - b.score,
  }, {
    title: '发文时间',
    dataIndex: 'postTime',
    sorter: (a, b) => new Date(a.postTime) - new Date(b.postTime),
  }, {
    title: '建议',
    dataIndex: 'message',
  }, {
    title: '操作',
    key: 'option'
  }]

  export const tableGameColumns= [
    {
      title: '用户头像',
      key: 'imgSrc',
      fixed: true
    },
    {
      title: '用户id',
      dataIndex: 'uid',
      sorter: (a, b) => a.uid[0].charCodeAt() - b.uid[0].charCodeAt(),
    }, {
      title: '用户昵称',
      sorter: true,
      key: 'name',
    }, 
    {
      title: '报名状态',
      sorter: true,
      dataIndex: 'status',
      sorter: (a, b) => a.status[0].charCodeAt() - b.status[0].charCodeAt(),
    },
    {
      title: '城市',
      sorter: true,
      dataIndex: 'ip',
      sorter: (a, b) => a.ip[0].charCodeAt() - b.ip[0].charCodeAt(),
      filters: [
        {
          text: '广东省',
          value: '广东省',
        }
      ]
    }
  ]