/**
 * 模型；valobj - 值对象、entity - 实体、aggregate - 聚合根
 *
 * DDD中，值对象、实体对象和聚合根对象的定义是根据业务领域的语义来进行的。
 * 一般来说，实体对象表示具有唯一标识的业务实体，例如订单、商品、用户等；
 * 聚合根对象是一组相关的实体对象的根，用于保证实体对象之间的一致性和完整性；
 * 而值对象则表示没有唯一标识的业务实体，例如商品的名称、描述、价格等。
 *
 * 在DDD中，聚合是一个有边界的事物集合，它包含了一个聚合根和一些相关的实体和值对象。聚合根是聚合的入口点，它定义了聚合的边界，并负责保护聚合内的不变量。聚合内的实体和值对象则是聚合根的子对象，它们只能通过聚合根来访问。
 * 在聚合中，逻辑应该是与聚合根相关的业务逻辑，而不是将所有的服务功能都放到聚合对象中。聚合对象应该包含与聚合根相关的操作和规则，例如聚合根的创建、修改和删除等操作，以及聚合根的不变量验证等规则。聚合对象还可以包含一些与聚合根相关的查询操作，但是这些查询操作应该是只读的，不应该对聚合根的状态进行修改。
 * 至于服务功能，它们可以被实现为应用服务或领域服务，它们可以与聚合对象协同工作，但不应该被包含在聚合对象中。应用服务和领域服务可以调用聚合对象来完成业务逻辑，但是它们不应该直接修改聚合根的状态。
 */
package cn.bugstack.xfg.frame.domain.order.model;