package cn.bugstack.infrastructure.persistent.po;

import lombok.Data;

import java.util.Date;

/**
 * @description: 规则树节点连线
 * @author: hdr
 * @PACKAGE_NAME: cn.bugstack.infrastructure.persistent.po
 * @DATE: 2024/4/23
 */
@Data
public class RuleTreeNodeLine {

    /**
     * 自增ID
     */
    private Long id;
    /**
     * 规则树ID
     */
    private String treeId;
    /**
     * 规则key节点 from
     */
    private String ruleNodeFrom;
    /**
     * 规则key节点 to
     */
    private String ruleNodeTo;
    /**
     * 限定类型：1:=;2:>;3:<;4:>=;5<=;6:enum[枚举范围]
     */
    private String ruleLimitType;
    /**
     * 限定值（到下个节点）
     */
    private String ruleLimitValue;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
}
