package cn.bugstack.domain.strategy.repository;

import cn.bugstack.domain.strategy.model.entity.StrategyAwardEntity;
import cn.bugstack.domain.strategy.model.entity.StrategyEntity;
import cn.bugstack.domain.strategy.model.entity.StrategyRuleEntity;
import cn.bugstack.domain.strategy.model.valobj.StrategyAwardRuleModelVO;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 策略仓储接口
 * @author: hdr
 * @PACKAGE_NAME: cn.bugstack.domain.strategy.repository
 * @DATE: 2024/4/5
 */
public interface IStrategyRepository {

    /**
     *  查询策略对应的数据
     * @param strategy 策略id
     * @return 策略数据
     */
    List<StrategyAwardEntity> queryStrategyAwardList(Long strategy);

    /**
     *  @param key 策略id
     * @param rateRange 概率
     * @param shuffleStrategyAwardSearchRateTables 所有保存的概率
     */
    void storeStrategyAwardSearchRateTables(String key, Integer rateRange, HashMap<Integer, Integer> shuffleStrategyAwardSearchRateTables);

    /**
     *
     * @param strategyId 获取概率值
     * @return
     */
    int getRandomAwardId(Long strategyId);

    /**
     * 获取奖品id
     * @param key
     * @param nextInt
     * @return
     */
    Integer getStrategyAwardAssemble(String key, int nextInt);

    /**
     * 获取抽奖策略
     * @param strategy 策略id
     * @return
     */
    StrategyEntity queryStrategyEntityByStrategyId(Long strategy);

    /**
     *  查询抽奖策略规则
     * @param strategy   策略id
     * @param ruleWeight 策略id
     * @return
     */
    StrategyRuleEntity queryStrategyRule(Long strategyId, String ruleWeight);

    /**
     * 获取概率值
     * @param key
     * @return
     */
    int getRateRange(String key);

    /**
     * 查询策略规则值
     * @param strategyId  策略jd
     * @param ruleModel   奖品id
     * @return            策略规则
     */
    String queryStrategyRuleValue(Long strategyId, String ruleModel);

    /**
     * 查询策略规则值
     * @param strategyId 策略id
     * @param awardId    奖品id
     * @param ruleModel  规则模型
     * @return
     */
    String queryStrategyRuleValue(Long strategyId, Integer awardId, String ruleModel);

    /**
     * 查询 ruleModel
     * @param strategyId
     * @param awardId
     * @return
     */
    StrategyAwardRuleModelVO queryStrategyAwardRuleModelVO(Long strategyId, Integer awardId);
}
