package cn.bugstack.domain.strategy.repository;

import cn.bugstack.domain.strategy.model.entity.StrategyAwardEntity;
import cn.bugstack.domain.strategy.model.entity.StrategyEntity;
import cn.bugstack.domain.strategy.model.entity.StrategyRuleEntity;
import cn.bugstack.domain.strategy.model.valobj.RuleTreeVO;
import cn.bugstack.domain.strategy.model.valobj.StrategyAwardRuleModelVO;
import cn.bugstack.domain.strategy.model.valobj.StrategyAwardStockKeyVO;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 策略仓储接口
 * @author: hdr
 * @PACKAGE_NAME: cn.bugstack.domain.strategy.repository
 * @DATE: 2024/4/5
 */
public interface IStrategyRepository {

    /**
     *  查询策略对应的数据
     * @param strategy 策略id
     * @return 策略数据
     */
    List<StrategyAwardEntity> queryStrategyAwardList(Long strategy);

    /**
     *  @param key 策略id
     * @param rateRange 概率
     * @param shuffleStrategyAwardSearchRateTables 所有保存的概率
     */
    void storeStrategyAwardSearchRateTables(String key, Integer rateRange, Map<Integer, Integer> shuffleStrategyAwardSearchRateTables);

    /**
     *
     * @param strategyId 获取概率值
     * @return
     */
    int getRandomAwardId(Long strategyId);

    /**
     * 获取奖品id
     * @param key
     * @param nextInt
     * @return
     */
    Integer getStrategyAwardAssemble(String key, int nextInt);

    /**
     * 获取抽奖策略
     * @param strategy 策略id
     * @return
     */
    StrategyEntity queryStrategyEntityByStrategyId(Long strategy);

    /**
     *  查询抽奖策略规则
     * @param strategy   策略id
     * @param ruleWeight 策略id
     * @return
     */
    StrategyRuleEntity queryStrategyRule(Long strategyId, String ruleWeight);

    /**
     * 获取概率值
     * @param key
     * @return
     */
    int getRateRange(String key);

    /**
     * 查询策略规则值
     * @param strategyId  策略jd
     * @param ruleModel   奖品id
     * @return            策略规则
     */
    String queryStrategyRuleValue(Long strategyId, String ruleModel);

    /**
     * 查询策略规则值
     * @param strategyId 策略id
     * @param awardId    奖品id
     * @param ruleModel  规则模型
     * @return
     */
    String queryStrategyRuleValue(Long strategyId, Integer awardId, String ruleModel);

    /**
     * 查询 ruleModel
     * @param strategyId
     * @param awardId
     * @return
     */
    StrategyAwardRuleModelVO queryStrategyAwardRuleModelVO(Long strategyId, Integer awardId);

    /**
     * 根据规则树ID，查询树结构信息
     *
     * @param treeId 规则树ID
     * @return 树结构信息
     */
    RuleTreeVO queryRuleTreeVOByTreeId(String treeId);

    /**
     * 缓存奖品库存
     *
     * @param cacheKey    key
     * @param awardCount  库存值
     */
    void cacheStrategyAwardCount(String cacheKey, Integer awardCount);

    /**
     * 缓存key，decr 方式扣减库存
     * @param cacheKey 缓存key
     * @return         扣减结果
     */
    boolean subtractionAwardStock(String cacheKey);

    /**
     * 写入奖品库存消费对接
     * @param strategyAwardStockKeyVO
     */
    void awardStockConsumeSendQueue(StrategyAwardStockKeyVO strategyAwardStockKeyVO);

    /**
     * 获取奖品库存消费对列
     */
    StrategyAwardStockKeyVO takeQueueValue() throws InterruptedException;

    /**
     * 更新奖品库存消耗
     *
     * @param strategyId 策略ID
     * @param awardId 奖品ID
     */
    void updateStrategyAwardStock(Long strategyId, Integer awardId);
}
