package cn.bugstack.infrastructure.persistent.dao;

import cn.bugstack.infrastructure.persistent.po.StrategyAward;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Fuzhengwei bugstack.cn @小傅哥
 * @description 抽奖策略奖品明细配置 - 概率、规则 DAO
 * @create 2023-12-16 13:24
 */
@Mapper
public interface IStrategyAwardDao {

    List<StrategyAward> queryStrategyAwardList();

    /**
     * 查询策略下的数据
     * @param strategyId
     * @return
     */
    List<StrategyAward> queryStrategyAwardListByStrategyId(@Param("strategyId") Long strategyId);

    /**
     * 查询ruleModels
     * @param strategyAward
     * @return
     */
    String queryStrategyAwardRuleModels(StrategyAward strategyAward);

    /**
     * 更新策略获奖奖品
     * @param strategyAward
     */
    void updateStrategyAwardStock(StrategyAward strategyAward);

    /**
     *
     * @param strategyAwardReq
     * @return
     */
    StrategyAward queryStrategyAward(StrategyAward strategyAwardReq);
}
