# 完整项目代码清单

## 📚 说明

本文档列出了实现 `db-router-spring-boot-starter` 项目所需的所有代码文件。按照30天的学习计划，逐步实现这些文件。

---

## 📁 项目结构

```
db-router-spring-boot-starter/
├── pom.xml
├── src/
│   ├── main/
│   │   ├── java/
│   │   │   └── cn/bugstack/middleware/db/router/
│   │   │       ├── annotation/
│   │   │       │   ├── DBRouter.java
│   │   │       │   └── DBRouterStrategy.java
│   │   │       ├── config/
│   │   │       │   └── DataSourceAutoConfig.java
│   │   │       ├── dynamic/
│   │   │       │   ├── DynamicDataSource.java
│   │   │       │   └── DynamicMybatisPlugin.java
│   │   │       ├── strategy/
│   │   │       │   ├── IDBRouterStrategy.java
│   │   │       │   └── impl/
│   │   │       │       └── DBRouterStrategyHashCode.java
│   │   │       ├── util/
│   │   │       │   ├── StringUtils.java
│   │   │       │   └── PropertyUtil.java
│   │   │       ├── DBContextHolder.java
│   │   │       ├── DBRouterBase.java
│   │   │       ├── DBRouterConfig.java
│   │   │       └── DBRouterJoinPoint.java
│   │   └── resources/
│   │       └── META-INF/
│   │           └── spring.factories
│   └── test/
│       └── java/
```

---

## 📝 文件清单

### 1. pom.xml
**位置**：项目根目录  
**说明**：Maven配置文件，包含所有依赖  
**实现日期**：第01天

### 2. DBRouter.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/annotation/`  
**说明**：数据库路由注解  
**实现日期**：第03天

### 3. DBRouterStrategy.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/annotation/`  
**说明**：数据库路由策略注解  
**实现日期**：第03天

### 4. PropertyUtil.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/util/`  
**说明**：属性工具类，用于反射获取属性值  
**实现日期**：第04天

### 5. StringUtils.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/util/`  
**说明**：字符串工具类  
**实现日期**：第11天

### 6. DBRouterConfig.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/`  
**说明**：数据库路由配置类  
**实现日期**：第11天

### 7. IDBRouterStrategy.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/strategy/`  
**说明**：路由策略接口  
**实现日期**：第10天

### 8. DBRouterStrategyHashCode.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/strategy/impl/`  
**说明**：哈希路由策略实现  
**实现日期**：第12天

### 9. DBContextHolder.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/`  
**说明**：数据库路由上下文持有者，使用ThreadLocal存储路由信息  
**实现日期**：第08天

### 10. DBRouterBase.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/`  
**说明**：数据库路由基类  
**实现日期**：第12天

### 11. DynamicDataSource.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/dynamic/`  
**说明**：动态数据源，继承AbstractRoutingDataSource  
**实现日期**：第09天

### 12. DynamicMybatisPlugin.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/dynamic/`  
**说明**：MyBatis插件，用于修改SQL中的表名  
**实现日期**：第07天、第14天

### 13. DBRouterJoinPoint.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/`  
**说明**：AOP切面，拦截带@DBRouter注解的方法  
**实现日期**：第05天、第13天

### 14. DataSourceAutoConfig.java
**位置**：`src/main/java/cn/bugstack/middleware/db/router/config/`  
**说明**：数据源自动配置类  
**实现日期**：第06天、第15天

### 15. spring.factories
**位置**：`src/main/resources/META-INF/`  
**说明**：Spring Boot自动配置入口文件  
**实现日期**：第16天

---

## 🔄 实现顺序

### 第一阶段：基础知识（第01-10天）
1. 项目初始化（pom.xml）
2. 理解数据库路由概念
3. 实现注解（DBRouter、DBRouterStrategy）
4. 实现工具类（PropertyUtil）
5. 理解AOP和实现切面（DBRouterJoinPoint）
6. 理解自动配置（DataSourceAutoConfig）
7. 实现MyBatis插件（DynamicMybatisPlugin）
8. 实现上下文持有者（DBContextHolder）
9. 实现动态数据源（DynamicDataSource）
10. 设计策略接口（IDBRouterStrategy）

### 第二阶段：核心实现（第11-20天）
11. 实现配置类和工具类（DBRouterConfig、StringUtils）
12. 实现路由策略（DBRouterStrategyHashCode、DBRouterBase）
13. 完善AOP切面（DBRouterJoinPoint）
14. 完善MyBatis插件（DynamicMybatisPlugin）
15. 完善自动配置（DataSourceAutoConfig）
16. 创建spring.factories
17-20. 测试和优化

### 第三阶段：功能完善（第21-30天）
21-30. 功能完善、测试、文档

---

## 📋 检查清单

完成每个文件后，在对应日期打勾：

### 注解
- [ ] DBRouter.java（第03天）
- [ ] DBRouterStrategy.java（第03天）

### 配置
- [ ] DBRouterConfig.java（第11天）
- [ ] DataSourceAutoConfig.java（第06天、第15天）

### 核心类
- [ ] DBContextHolder.java（第08天）
- [ ] DBRouterJoinPoint.java（第05天、第13天）
- [ ] DBRouterBase.java（第12天）

### 动态数据源
- [ ] DynamicDataSource.java（第09天）
- [ ] DynamicMybatisPlugin.java（第07天、第14天）

### 策略
- [ ] IDBRouterStrategy.java（第10天）
- [ ] DBRouterStrategyHashCode.java（第12天）

### 工具类
- [ ] StringUtils.java（第11天）
- [ ] PropertyUtil.java（第04天）

### 配置文件
- [ ] pom.xml（第01天）
- [ ] spring.factories（第16天）

---

## 🎯 使用说明

1. **按顺序学习**：从第01天开始，每天完成一个文件
2. **理解原理**：不要只是复制代码，要理解为什么这样写
3. **动手实践**：每学一个知识点就写代码验证
4. **记录问题**：遇到问题记录下来，逐步解决
5. **拓展思考**：完成拓展练习，加深理解

---

## 💡 提示

- 所有代码都在对应的日期文件中
- 每个文件都有详细的代码和解释
- 遇到问题可以查看对应日期的文件
- 完成所有文件后，项目就可以使用了

---

**祝你学习顺利！** 🎉
