# 第01天：项目初始化和Maven配置

## 📚 今日目标

1. 理解什么是Spring Boot
2. 理解什么是Spring Boot Starter
3. 创建Maven项目结构
4. 配置pom.xml文件
5. 理解项目依赖关系

---

## 🎯 知识点0：什么是Spring Boot？（先理解这个）

### 生活中的例子

**传统Java开发 vs Spring Boot开发**

**传统方式（复杂）**：
```
想象你要做一道菜：
1. 买锅（配置Tomcat服务器）
2. 买调料（配置各种XML文件）
3. 准备食材（写很多配置代码）
4. 生火（启动服务器）
5. 炒菜（写业务代码）
```

**Spring Boot方式（简单）**：
```
Spring Boot就像"外卖套餐"：
1. 打开包装（引入依赖）
2. 加热（运行main方法）
3. 开吃（直接写业务代码）
```

### 最简单的例子

**传统Spring项目**（需要配置很多XML）：

```java
// 1. 需要web.xml配置
// 2. 需要applicationContext.xml配置
// 3. 需要配置数据源、事务等
// 4. 需要部署到Tomcat服务器
// ... 很多配置
```

**Spring Boot项目**（几乎零配置）：

```java
// 1. 创建一个类
@SpringBootApplication
public class MyApp {
    public static void main(String[] args) {
        SpringApplication.run(MyApp.class, args);
    }
}

// 2. 运行main方法
// 3. 完成！服务器自动启动，可以访问了
```

### Spring Boot的核心特点

**1. 自动配置（Auto Configuration）**
```
传统方式：需要手动配置每个组件
Spring Boot：检测到classpath中的类，自动配置
```

**例子**：
```java
// 传统方式：需要手动配置数据源
@Configuration
public class DataSourceConfig {
    @Bean
    public DataSource dataSource() {
        // 写很多配置代码
    }
}

// Spring Boot：引入依赖，自动配置
// 只需要在application.yml中写：
spring:
  datasource:
    url: jdbc:mysql://localhost:3306/test
    username: root
    password: 123456
// 数据源自动创建好了！
```

**2. 起步依赖（Starter Dependencies）**
```
传统方式：需要一个个引入依赖，还要处理版本冲突
Spring Boot：引入一个starter，自动引入所有相关依赖
```

**例子**：
```xml
<!-- 传统方式：需要引入很多依赖 -->
<dependency>
    <groupId>org.springframework</groupId>
    <artifactId>spring-web</artifactId>
</dependency>
<dependency>
    <groupId>org.springframework</groupId>
    <artifactId>spring-webmvc</artifactId>
</dependency>
<!-- ... 还有很多 -->

<!-- Spring Boot方式：一个依赖搞定 -->
<dependency>
    <groupId>org.springframework.boot</groupId>
    <artifactId>spring-boot-starter-web</artifactId>
</dependency>
<!-- 自动包含了所有web开发需要的依赖 -->
```

**3. 内嵌服务器（Embedded Server）**
```
传统方式：需要安装Tomcat，打包成war，部署到服务器
Spring Boot：内嵌Tomcat，打包成jar，直接运行
```

**例子**：
```bash
# 传统方式
1. 打包成war文件
2. 部署到Tomcat
3. 启动Tomcat
4. 访问应用

# Spring Boot方式
1. 打包成jar文件
2. java -jar app.jar
3. 完成！直接访问
```

### 最简单的完整例子

**创建一个Web接口**：

```java
// 1. 主类
@SpringBootApplication
public class HelloApp {
    public static void main(String[] args) {
        SpringApplication.run(HelloApp.class, args);
    }
}

// 2. 控制器（处理HTTP请求）
@RestController
public class HelloController {
    @GetMapping("/hello")
    public String hello() {
        return "Hello Spring Boot!";
    }
}

// 3. 运行main方法
// 4. 浏览器访问：http://localhost:8080/hello
// 5. 看到：Hello Spring Boot!
```

**就这么简单！**
- 不需要配置web.xml
- 不需要配置Tomcat
- 不需要部署
- 直接运行，直接访问

### 为什么用Spring Boot？

**传统Spring的问题**：
- ❌ 配置复杂（XML、Java配置）
- ❌ 依赖管理困难（版本冲突）
- ❌ 部署复杂（需要服务器）
- ❌ 开发效率低

**Spring Boot的优势**：
- ✅ 零配置（约定优于配置）
- ✅ 自动配置（开箱即用）
- ✅ 内嵌服务器（直接运行）
- ✅ 开发效率高

### 总结

**Spring Boot = Spring框架 + 自动配置 + 起步依赖 + 内嵌服务器**

**核心思想**：**约定优于配置**
- 不需要配置的，就不配置
- 有默认值的，就用默认值
- 需要配置的，才配置

---

## 🎯 知识点1：什么是Spring Boot Starter？

### 为什么需要Starter？

**问题场景**：
- 每次使用某个框架（如MyBatis），都要手动配置很多Bean
- 配置复杂，容易出错
- 不同项目重复配置

**解决方案**：Spring Boot Starter
- 把常用配置打包成一个依赖
- 引入依赖后自动配置
- 开箱即用，零配置

**例子**：
```xml
<!-- 引入这个依赖 -->
<dependency>
    <groupId>org.mybatis.spring.boot</groupId>
    <artifactId>mybatis-spring-boot-starter</artifactId>
</dependency>

<!-- 自动就有了：
- SqlSessionFactory
- SqlSessionTemplate  
- Mapper扫描
- 等等...
-->
```

### 我们的目标

创建一个 `db-router-spring-boot-starter`，让用户：
1. 引入依赖
2. 配置几个参数
3. 使用 `@DBRouter` 注解
4. 自动实现分库分表

---

## 🎯 知识点2：Maven项目结构

### 标准Maven项目结构

```
db-router-spring-boot-starter/
├── pom.xml                          # Maven配置文件
├── src/
│   ├── main/
│   │   ├── java/                    # Java源代码
│   │   │   └── cn/bugstack/middleware/db/router/
│   │   │       ├── annotation/      # 注解
│   │   │       ├── config/          # 配置类
│   │   │       ├── dynamic/         # 动态数据源
│   │   │       ├── strategy/        # 路由策略
│   │   │       └── util/            # 工具类
│   │   └── resources/
│   │       └── META-INF/
│   │           └── spring.factories # 自动配置入口
│   └── test/                        # 测试代码
│       └── java/
```

### 为什么这样组织？

- **annotation**：存放自定义注解（@DBRouter等）
- **config**：Spring配置类（自动配置）
- **dynamic**：动态数据源相关类
- **strategy**：路由策略（策略模式）
- **util**：工具类（字符串、属性等）

---

## 🛠️ 实践任务1：创建项目结构

### 步骤1：创建目录

在你的项目根目录执行：

```bash
mkdir -p src/main/java/cn/bugstack/middleware/db/router/{annotation,config,dynamic,strategy/impl,util}
mkdir -p src/main/resources/META-INF
mkdir -p src/test/java
```

### 步骤2：验证结构

```bash
tree src/  # 如果没有tree命令，用 find src -type d
```

应该看到：
```
src/
├── main
│   ├── java
│   │   └── cn
│   │       └── bugstack
│   │           └── middleware
│   │               └── db
│   │                   └── router
│   │                       ├── annotation
│   │                       ├── config
│   │                       ├── dynamic
│   │                       ├── strategy
│   │                       │   └── impl
│   │                       └── util
│   └── resources
│       └── META-INF
└── test
    └── java
```

---

## 🛠️ 实践任务2：创建pom.xml

### 完整pom.xml代码

在项目根目录创建 `pom.xml`：

```xml
<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 
         http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <!-- 项目坐标 -->
    <groupId>cn.bugstack.middleware</groupId>
    <artifactId>db-router-spring-boot-starter</artifactId>
    <version>1.0.2</version>
    <packaging>jar</packaging>

    <!-- 继承Spring Boot父项目 -->
    <parent>
        <groupId>org.springframework.boot</groupId>
        <artifactId>spring-boot-starter-parent</artifactId>
        <version>2.3.5.RELEASE</version>
        <relativePath/>
    </parent>

    <properties>
        <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>
        <maven.compiler.source>1.8</maven.compiler.source>
        <maven.compiler.target>1.8</maven.compiler.target>
    </properties>

    <dependencies>
        <!-- Spring Boot 核心 -->
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-starter</artifactId>
        </dependency>

        <!-- Spring Boot 自动配置 -->
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-autoconfigure</artifactId>
        </dependency>

        <!-- Spring Boot 配置处理器（用于IDE提示） -->
        <!-- 
            可选依赖：只是用于IDE自动提示配置属性
            原因：optional=true，不会传递到用户项目
            建议：开发时保留，可以让IDE提示配置项；如果不需要提示，可以注释掉
        -->
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-configuration-processor</artifactId>
            <optional>true</optional>
        </dependency>

        <!-- Spring Boot AOP -->
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-starter-aop</artifactId>
        </dependency>

        <!-- MyBatis Spring Boot Starter -->
        <dependency>
            <groupId>org.mybatis.spring.boot</groupId>
            <artifactId>mybatis-spring-boot-starter</artifactId>
            <version>2.1.4</version>
        </dependency>

        <!-- MySQL驱动 -->
        <!-- 
            可选依赖：用户项目会自己引入数据库驱动
            原因：我们的starter不直接使用MySQL，只是示例配置中用到
            建议：如果只是学习，可以注释掉；如果要测试，需要保留
        -->
        <!--
        <dependency>
            <groupId>mysql</groupId>
            <artifactId>mysql-connector-java</artifactId>
            <version>5.1.34</version>
        </dependency>
        -->

        <!-- Apache Commons BeanUtils（用于反射获取属性） -->
        <!-- 必须：PropertyUtil.getProperty()方法使用 -->
        <dependency>
            <groupId>commons-beanutils</groupId>
            <artifactId>commons-beanutils</artifactId>
            <version>1.9.4</version>
        </dependency>

        <!-- Apache Commons Lang（字符串工具） -->
        <!-- 必须：StringUtils.isBlank()等方法使用 -->
        <dependency>
            <groupId>commons-lang</groupId>
            <artifactId>commons-lang</artifactId>
            <version>2.6</version>
        </dependency>

        <!-- FastJSON（JSON处理） -->
        <!-- 
            可选依赖：代码中没有使用FastJSON
            原因：检查了所有代码文件，没有找到fastjson的使用
            可以安全删除
        -->
        <!--
        <dependency>
            <groupId>com.alibaba</groupId>
            <artifactId>fastjson</artifactId>
            <version>1.2.75</version>
        </dependency>
        -->

        <!-- 测试依赖 -->
        <!-- 
            可选依赖：只在测试时需要
            原因：scope=test，不会打包到最终jar中
            建议：如果要写测试，保留；如果只是学习核心功能，可以注释掉
        -->
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-starter-test</artifactId>
            <scope>test</scope>
        </dependency>
        <!-- 
            JUnit依赖：可选
            原因：spring-boot-starter-test已经包含了JUnit
            可以删除，避免重复
        -->
        <!--
        <dependency>
            <groupId>junit</groupId>
            <artifactId>junit</artifactId>
            <version>4.12</version>
            <scope>test</scope>
        </dependency>
        -->
    </dependencies>

    <build>
        <finalName>db-router-spring-boot-starter</finalName>
        
        <plugins>
            <!-- Maven编译插件 -->
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-compiler-plugin</artifactId>
                <version>3.8.1</version>
                <configuration>
                    <source>1.8</source>
                    <target>1.8</target>
                    <encoding>UTF-8</encoding>
                </configuration>
            </plugin>

            <!-- 源码打包插件 -->
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-source-plugin</artifactId>
                <version>3.2.1</version>
                <executions>
                    <execution>
                        <id>attach-sources</id>
                        <goals>
                            <goal>jar</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>
        </plugins>
    </build>
</project>
```

### 依赖说明

**📋 依赖分类总结**：

**✅ 必须依赖（核心功能需要）**：
1. spring-boot-starter - Spring Boot核心
2. spring-boot-autoconfigure - 自动配置
3. spring-boot-starter-aop - AOP切面
4. mybatis-spring-boot-starter - MyBatis插件
5. commons-beanutils - 反射获取属性
6. commons-lang - 字符串工具

**❌ 可选依赖（已注释，可删除）**：
1. mysql-connector-java - 用户项目会自己引入
2. fastjson - 代码中没有使用
3. junit - spring-boot-starter-test已包含

**⚠️ 可选但建议保留**：
1. spring-boot-configuration-processor - IDE提示（optional=true，不影响运行时）
2. spring-boot-starter-test - 测试用（scope=test，不影响打包）

**📝 关于HikariCP的说明**：
- 第15天的DataSourceAutoConfig代码中使用了HikariCP创建数据源
- 但pom.xml中没有HikariCP依赖，因为：
  1. 用户项目通常会引入spring-boot-starter-jdbc（已包含HikariCP）
  2. 或者用户自己选择连接池（Druid、HikariCP等）
  3. 我们的starter不应该强制指定连接池
- 如果测试时需要，可以临时添加：
  ```xml
  <dependency>
      <groupId>com.zaxxer</groupId>
      <artifactId>HikariCP</artifactId>
  </dependency>
  ```

---

#### 1. Spring Boot Starter
```xml
<dependency>
    <groupId>org.springframework.boot</groupId>
    <artifactId>spring-boot-starter</artifactId>
</dependency>
```
**作用**：Spring Boot核心功能，包含自动配置、日志等

#### 2. Spring Boot Autoconfigure
```xml
<dependency>
    <groupId>org.springframework.boot</groupId>
    <artifactId>spring-boot-autoconfigure</artifactId>
</dependency>
```
**作用**：自动配置的核心，我们用它来实现自动配置

#### 3. Spring Boot AOP
```xml
<dependency>
    <groupId>org.springframework.boot</groupId>
    <artifactId>spring-boot-starter-aop</artifactId>
</dependency>
```
**作用**：AOP功能，用于拦截方法，实现路由逻辑

#### 4. MyBatis Spring Boot Starter
```xml
<dependency>
    <groupId>org.mybatis.spring.boot</groupId>
    <artifactId>mybatis-spring-boot-starter</artifactId>
</dependency>
```
**作用**：MyBatis集成，我们需要拦截SQL修改表名

#### 5. Commons BeanUtils
```xml
<dependency>
    <groupId>commons-beanutils</groupId>
    <artifactId>commons-beanutils</artifactId>
</dependency>
```
**作用**：通过反射获取对象属性值（如获取userId）  
**是否必须**：✅ 必须 - PropertyUtil.getProperty()方法使用

#### 6. Commons Lang
```xml
<dependency>
    <groupId>commons-lang</groupId>
    <artifactId>commons-lang</artifactId>
</dependency>
```
**作用**：字符串工具类（isBlank等方法）  
**是否必须**：✅ 必须 - StringUtils使用

#### 7. MySQL驱动
**是否必须**：❌ 可选 - 用户项目会自己引入数据库驱动

#### 8. FastJSON
**是否必须**：❌ 可选 - 代码中没有使用，可以删除

#### 9. 测试依赖
**是否必须**：❌ 可选 - 只在测试时需要（scope=test）

---

## 🎓 知识点拓展

### 拓展1：Maven依赖作用域（Scope）

```xml
<scope>compile</scope>    <!-- 默认，编译和运行时都需要 -->
<scope>provided</scope>   <!-- 编译时需要，运行时由容器提供（如servlet-api） -->
<scope>runtime</scope>    <!-- 运行时需要，编译时不需要（如JDBC驱动） -->
<scope>test</scope>       <!-- 只在测试时需要 -->
<scope>system</scope>     <!-- 系统路径，不推荐 -->
```

**为什么spring-boot-configuration-processor用optional？**
- `optional=true` 表示这个依赖不会传递
- 只在开发时用于IDE提示，运行时不需要
- 避免用户项目引入不必要的依赖

### 拓展2：Spring Boot版本选择

**为什么用2.3.5？**
- 这是原项目使用的版本
- 2.x版本稳定，兼容性好
- 3.x版本需要Java 17+，门槛更高

**如何选择版本？**
- 生产环境：选择稳定版本（如2.7.x）
- 学习环境：可以尝试最新版本
- 注意：不同版本API可能有差异

### 拓展3：Maven坐标（Coordinates）

```xml
<groupId>cn.bugstack.middleware</groupId>    <!-- 组织/公司 -->
<artifactId>db-router-spring-boot-starter</artifactId>  <!-- 项目名 -->
<version>1.0.2</version>                     <!-- 版本号 -->
```

**命名规范**：
- groupId：通常是域名倒写（如com.company.project）
- artifactId：项目名，小写，用连字符
- version：语义化版本（主版本.次版本.修订版本）

---

## ✅ 今日检查清单

- [ ] 创建了完整的项目目录结构
- [ ] 创建了pom.xml文件
- [ ] 理解了每个依赖的作用
- [ ] 能够解释为什么需要这些依赖
- [ ] 完成了拓展阅读

---

## 🎯 明日预告

明天我们将学习：
- 什么是数据库路由
- 为什么需要分库分表
- 路由的基本原理

---

## 💡 思考题

1. 如果不用Spring Boot Starter，用户需要手动配置哪些东西？
2. 为什么starter的依赖要用`optional=true`？
3. Maven的`<parent>`标签有什么作用？

---

## 📚 参考资源

- [Spring Boot官方文档](https://spring.io/projects/spring-boot)
- [Maven官方文档](https://maven.apache.org/guides/)
- [Spring Boot Starter开发指南](https://docs.spring.io/spring-boot/docs/current/reference/html/using.html#using.build-systems.starters)
