import argparse
import platform
import socket
import psutil

def main():
    parser = argparse.ArgumentParser(description='Description of your program')
    parser.add_argument('-i', '--input', help='Input file path', required=False)
    parser.add_argument('-o', '--output', help='Output file path', required=False)
    args = parser.parse_args()

    # 执行具体的操作逻辑
    # ...

# 定义一个获取本机操作系统信息的方法
def get_os_info():
    # 使用platform模块获取当前操作系统的名称
    os_name = platform.system()
    # 使用platform模块获取当前操作系统的版本号
    os_version = platform.release()
    # 将操作系统的名称和版本号拼接起来，返回结果字符串
    return f'{os_name} {os_version}'

# 定义一个获取本机IP地址的方法
def get_ip_address():
    # 使用socket模块获取本机的主机名
    hostname = socket.gethostname()
    # 使用socket模块获取本机的IP地址
    ip_address = socket.gethostbyname(hostname)
    # 返回获取到的IP地址字符串
    return ip_address


def get_system_info():
    # 获取 CPU 信息
    cpu_count = psutil.cpu_count()  # CPU 核心数
    cpu_freq = psutil.cpu_freq().current  # CPU 当前主频

    # 获取内存信息
    mem = psutil.virtual_memory()
    mem_total = mem.total // 1024 // 1024  # 总内存大小，单位 MB
    mem_used = mem.used // 1024 // 1024  # 已使用内存大小，单位 MB

    # 获取磁盘信息
    disk_partitions = psutil.disk_partitions()
    disk_usage = []
    for partition in disk_partitions:
        partition_usage = psutil.disk_usage(partition.mountpoint)
        disk_usage.append(
            {"mountpoint": partition.mountpoint,
             "total_size": partition_usage.total // 1024 // 1024,  # 总大小，单位 MB
             "used_size": partition_usage.used // 1024 // 1024,  # 已使用大小，单位 MB
             "free_size": partition_usage.free // 1024 // 1024})  # 剩余大小，单位 MB

    return {"cpu_count": cpu_count,
            "cpu_freq": cpu_freq,
            "mem_total": mem_total,
            "mem_used": mem_used,
            "disk_usage": disk_usage}


if __name__ == '__main__':
    main()
    os_info = f'当前操作系统为：{get_os_info()}'
    ip_info = f'当前IP地址为：{get_ip_address()}'
    system_info = f'当前IP地址为：{get_system_info()}'
    print(os_info)
    print(ip_info)
    print(system_info)
    





